/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceException;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GFileUtils;
import org.gradle.util.hash.HashUtil;

public class TarFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final ReadableResource resource;
    private final File tmpDir;

    public TarFileTree(ReadableResource resource, File tmpDir) {
        this.resource = resource;
        String expandDirName = String.format("%s_%s", resource.getBaseName(), HashUtil.createCompactMD5(resource.getURI().toString()));
        this.tmpDir = new File(tmpDir, expandDirName);
    }

    public String getDisplayName() {
        return String.format("TAR '%s'", this.resource.getDisplayName());
    }

    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.tmpDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        InputStream inputStream;
        try {
            inputStream = this.resource.read();
            assert (inputStream != null);
        }
        catch (MissingResourceException e) {
            DeprecationLogger.nagUserWith(String.format("The specified tar file %s does not exist and will be silently ignored. This behaviour has been deprecated and will cause an error in the next version of Gradle.", this.getDisplayName()));
            return;
        }
        catch (ResourceException e) {
            throw new InvalidUserDataException(String.format("Cannot expand %s.", this.getDisplayName()), e);
        }
        try {
            try {
                this.visitImpl(visitor, inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception e) {
            String message = "Unable to expand " + this.getDisplayName() + "\n" + "  The tar might be corrupted or it is compressed in an unexpected way.\n" + "  By default the tar tree tries to guess the compression based on the file extension.\n" + "  If you need to specify the compression explicitly please refer to the DSL reference.";
            throw new GradleException(message, e);
        }
    }

    private void visitImpl(FileVisitor visitor, InputStream inputStream) throws IOException {
        TarEntry entry;
        AtomicBoolean stopFlag = new AtomicBoolean();
        NoCloseTarInputStream tar = new NoCloseTarInputStream(inputStream);
        while (!stopFlag.get() && (entry = tar.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                visitor.visitDir(new DetailsImpl(entry, tar, stopFlag));
                continue;
            }
            visitor.visitFile(new DetailsImpl(entry, tar, stopFlag));
        }
    }

    private static class NoCloseTarInputStream
    extends TarInputStream {
        public NoCloseTarInputStream(InputStream is) {
            super(is);
        }

        public void close() throws IOException {
        }

        public TarEntry getCurrent() {
            return this.currEntry;
        }
    }

    private class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final TarEntry entry;
        private final NoCloseTarInputStream tar;
        private final AtomicBoolean stopFlag;
        private File file;
        private boolean read;

        public DetailsImpl(TarEntry entry, NoCloseTarInputStream tar, AtomicBoolean stopFlag) {
            this.entry = entry;
            this.tar = tar;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("tar entry %s!%s", TarFileTree.this.resource.getDisplayName(), this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(TarFileTree.this.tmpDir, this.entry.getName());
                this.copyTo(this.file);
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getModTime().getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            if (this.read && this.file != null) {
                return GFileUtils.openInputStream(this.file);
            }
            if (this.read || this.tar.getCurrent() != this.entry) {
                throw new UnsupportedOperationException(String.format("The contents of %s has already been read.", this));
            }
            this.read = true;
            return this.tar;
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }

        public int getMode() {
            return this.entry.getMode() & 0x1FF;
        }
    }
}

