/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOrUriNotationParser<T extends Serializable>
implements NotationParser<T> {
    private static final Pattern URI_SCHEME = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-\\.]*:.+");
    private static final Pattern ENCODED_URI = Pattern.compile("%([0-9a-fA-F]{2})");
    private final FileSystem fileSystem;

    public FileOrUriNotationParser(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add("File, URI, URL or CharSequence is supported");
    }

    @Override
    public T parseNotation(Object notation) throws UnsupportedNotationException {
        if (notation instanceof File) {
            return (T)((Serializable)notation);
        }
        if (notation instanceof URL) {
            try {
                notation = ((URL)notation).toURI();
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            if (uri.getScheme().equals("file")) {
                return (T)new File(uri.getPath());
            }
            return (T)uri;
        }
        if (notation instanceof CharSequence) {
            String notationString = notation.toString();
            if (notationString.startsWith("file:")) {
                return (T)new File(this.uriDecode(notationString.substring(5)));
            }
            for (File file : File.listRoots()) {
                String rootPath = file.getAbsolutePath();
                String normalisedStr = notationString;
                if (!this.fileSystem.isCaseSensitive()) {
                    rootPath = rootPath.toLowerCase();
                    normalisedStr = normalisedStr.toLowerCase();
                }
                if (!normalisedStr.startsWith(rootPath) && !normalisedStr.startsWith(rootPath.replace(File.separatorChar, '/'))) continue;
                return (T)new File(notationString);
            }
            if (URI_SCHEME.matcher(notationString).matches()) {
                try {
                    return (T)new URI(notationString);
                }
                catch (URISyntaxException e) {
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            DeprecationLogger.nagUserWith(String.format("Converting class %s to File using toString() Method.  This has been deprecated and will be removed in the next version of Gradle. Please use java.io.File, java.lang.String, java.net.URL, or java.net.URI instead.", notation.getClass().getName()));
        }
        return (T)new File(notation.toString());
    }

    private String uriDecode(String path) {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = ENCODED_URI.matcher(path);
        while (matcher.find()) {
            String val = matcher.group(1);
            matcher.appendReplacement(builder, String.valueOf((char)Integer.parseInt(val, 16)));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }
}

