/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;

public abstract class AbstractFileTreeElement
implements FileTreeElement {
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.getRelativePath().getLastName();
    }

    public String getPath() {
        return this.getRelativePath().getPathString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream outstr) {
        try {
            InputStream inputStream = this.open();
            try {
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outstr);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean copyTo(File target) {
        this.validateTimeStamps();
        try {
            target.getParentFile().mkdirs();
            if (this.isDirectory()) {
                target.mkdirs();
            } else {
                this.copyFile(target);
            }
            FileSystems.getDefault().chmod(target, this.getMode());
            return true;
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not copy %s to '%s'.", this.getDisplayName(), target), e);
        }
    }

    private void validateTimeStamps() {
        long lastModified = this.getLastModified();
        if (lastModified < 0L) {
            throw new GradleException(String.format("Invalid Timestamp %s for '%s'.", lastModified, this.getDisplayName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File target) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(target);
        try {
            this.copyTo(outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public int getMode() {
        return this.isDirectory() ? 493 : 420;
    }
}

