/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedDependencyResultSorter {
    public static Collection<ResolvedDependencyResult> sort(Collection<ResolvedDependencyResult> input) {
        LinkedList<ResolvedDependencyResult> out = new LinkedList<ResolvedDependencyResult>(input);
        Collections.sort(out, new DependencyComparator());
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyComparator
    implements Comparator<ResolvedDependencyResult> {
        private DependencyComparator() {
        }

        @Override
        public int compare(ResolvedDependencyResult left, ResolvedDependencyResult right) {
            int byGroup = left.getRequested().getGroup().compareTo(right.getRequested().getGroup());
            if (byGroup != 0) {
                return byGroup;
            }
            int byModule = left.getRequested().getName().compareTo(right.getRequested().getName());
            if (byModule != 0) {
                return byModule;
            }
            if (left.getSelected().getId().equals(DefaultModuleVersionIdentifier.newId(left.getRequested()))) {
                return -1;
            }
            if (right.getSelected().getId().equals(DefaultModuleVersionIdentifier.newId(right.getRequested()))) {
                return 1;
            }
            return left.getRequested().getVersion().compareTo(right.getRequested().getVersion());
        }
    }
}

