/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedModuleVersionResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedDependencyResult;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolvedModuleVersionResult
implements ResolvedModuleVersionResult {
    private final ModuleVersionIdentifier id;
    private final Set<DefaultResolvedDependencyResult> dependencies = new LinkedHashSet<DefaultResolvedDependencyResult>();
    private final Set<DefaultResolvedModuleVersionResult> dependees = new LinkedHashSet<DefaultResolvedModuleVersionResult>();

    public DefaultResolvedModuleVersionResult(ModuleVersionIdentifier id) {
        assert (id != null);
        this.id = id;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    public Set<DefaultResolvedDependencyResult> getDependencies() {
        return CollectionUtils.filter(this.dependencies, new LinkedHashSet(), new Spec<DefaultResolvedDependencyResult>(){

            @Override
            public boolean isSatisfiedBy(DefaultResolvedDependencyResult element) {
                return !element.getSelectedConfigurations().isEmpty();
            }
        });
    }

    public Set<DefaultResolvedModuleVersionResult> getDependees() {
        return this.dependees;
    }

    public DefaultResolvedModuleVersionResult linkDependency(DefaultResolvedDependencyResult dependencyResult) {
        this.dependencies.add(dependencyResult);
        dependencyResult.getSelected().dependees.add(this);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedModuleVersionResult)) {
            return false;
        }
        ResolvedModuleVersionResult that = (ResolvedModuleVersionResult)o;
        return this.id.equals(that.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.getGroup() + ":" + this.id.getName() + ":" + this.id.getVersion();
    }
}

