/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedModuleVersionResult;
import org.gradle.api.internal.artifacts.result.ResolvedDependencyResultPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolvedDependencyResult
implements ResolvedDependencyResult {
    private final Set<String> configurations = new LinkedHashSet<String>();
    private final SelectionId selection;

    public DefaultResolvedDependencyResult(ModuleVersionSelector requested, ModuleVersionIdentifier selected, Collection<String> configurations) {
        assert (requested != null);
        assert (selected != null);
        assert (configurations != null);
        this.selection = new SelectionId(requested, new DefaultResolvedModuleVersionResult(selected));
        this.configurations.addAll(configurations);
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.selection.requested;
    }

    @Override
    public DefaultResolvedModuleVersionResult getSelected() {
        return this.selection.selected;
    }

    public Set<String> getSelectedConfigurations() {
        return this.configurations;
    }

    public void appendConfigurations(Set<String> configurations) {
        this.configurations.addAll(configurations);
    }

    public Object getSelectionId() {
        return this.selection;
    }

    public String toString() {
        return ResolvedDependencyResultPrinter.print(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultResolvedDependencyResult)) {
            return false;
        }
        DefaultResolvedDependencyResult that = (DefaultResolvedDependencyResult)o;
        if (!this.configurations.equals(that.configurations)) {
            return false;
        }
        return this.selection.equals(that.selection);
    }

    public int hashCode() {
        int result = this.configurations.hashCode();
        result = 31 * result + this.selection.hashCode();
        return result;
    }

    private static class SelectionId {
        final ModuleVersionSelector requested;
        final DefaultResolvedModuleVersionResult selected;

        public SelectionId(ModuleVersionSelector requested, DefaultResolvedModuleVersionResult selected) {
            this.requested = requested;
            this.selected = selected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectionId)) {
                return false;
            }
            SelectionId selection = (SelectionId)o;
            if (!this.requested.equals(selection.requested)) {
                return false;
            }
            return this.selected.equals(selection.selected);
        }

        public int hashCode() {
            int result = this.requested.hashCode();
            result = 31 * result + this.selected.hashCode();
            return result;
        }
    }
}

