/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.gradle.api.Transformer;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatestRevisionSelector {
    public String latest(Collection<String> versions) {
        LinkedList infos = CollectionUtils.collect(versions, new LinkedList(), new Transformer<DefaultArtifactInfo, String>(){

            @Override
            public DefaultArtifactInfo transform(String version) {
                return new DefaultArtifactInfo(version);
            }
        });
        return ((DefaultArtifactInfo)Collections.max(infos, new LatestRevisionStrategy().getComparator())).version;
    }

    private static class DefaultArtifactInfo
    implements ArtifactInfo {
        private String version;

        public DefaultArtifactInfo(String version) {
            this.version = version;
        }

        public String getRevision() {
            return this.version;
        }

        public long getLastModified() {
            throw new UnsupportedOperationException();
        }
    }
}

