/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.artifacts.ConflictResolution;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.internal.artifacts.configurations.ForcedModuleNotationParser;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.conflicts.LatestConflictResolution;
import org.gradle.api.internal.artifacts.configurations.conflicts.StrictConflictResolution;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.DefaultCachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolutionStrategy
implements ResolutionStrategyInternal {
    private Set<ModuleVersionSelector> forcedModules = new LinkedHashSet<ModuleVersionSelector>();
    private ConflictResolution conflictResolution = new LatestConflictResolution();
    private final DefaultCachePolicy cachePolicy = new DefaultCachePolicy();

    @Override
    public Set<ModuleVersionSelector> getForcedModules() {
        return this.forcedModules;
    }

    @Override
    public ResolutionStrategy failOnVersionConflict() {
        this.conflictResolution = new StrictConflictResolution();
        return this;
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public ResolutionRules getResolutionRules() {
        return this.cachePolicy;
    }

    @Override
    public DefaultResolutionStrategy force(Object ... forcedModuleNotations) {
        assert (forcedModuleNotations != null) : "forcedModuleNotations cannot be null";
        this.forcedModules.addAll((Collection<ModuleVersionSelector>)new ForcedModuleNotationParser().parseNotation(forcedModuleNotations));
        return this;
    }

    @Override
    public DefaultResolutionStrategy setForcedModules(Object ... forcedModuleNotations) {
        this.forcedModules = new ForcedModuleNotationParser().parseNotation(forcedModuleNotations);
        return this;
    }

    @Override
    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    @Override
    public void cacheDynamicVersionsFor(int value, String units) {
        TimeUnit timeUnit = TimeUnit.valueOf(units.toUpperCase());
        this.cacheDynamicVersionsFor(value, timeUnit);
    }

    @Override
    public void cacheDynamicVersionsFor(int value, TimeUnit units) {
        this.cachePolicy.cacheDynamicVersionsFor(value, units);
    }

    @Override
    public void cacheChangingModulesFor(int value, String units) {
        TimeUnit timeUnit = TimeUnit.valueOf(units.toUpperCase());
        this.cacheChangingModulesFor(value, timeUnit);
    }

    @Override
    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.cachePolicy.cacheChangingModulesFor(value, units);
    }
}

