/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;

public class DefaultModuleVersionIdentifier
implements ModuleVersionIdentifier,
ModuleVersionSelector {
    private final String group;
    private final String name;
    private final String version;

    public DefaultModuleVersionIdentifier(String group, String name, String version) {
        assert (group != null) : "group cannot be null";
        assert (name != null) : "name cannot be null";
        assert (version != null) : "version cannot be null";
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("{group: %s, module: %s, version: %s}", this.group, this.name, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleVersionIdentifier other = (DefaultModuleVersionIdentifier)obj;
        if (!this.group.equals(other.group)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.group.hashCode() ^ this.name.hashCode() ^ this.version.hashCode();
    }

    public static ModuleVersionIdentifier newId(Module module) {
        return new DefaultModuleVersionIdentifier(module.getGroup(), module.getName(), module.getVersion());
    }

    public static ModuleVersionIdentifier newId(ModuleVersionSelector selector) {
        return new DefaultModuleVersionIdentifier(selector.getGroup(), selector.getName(), selector.getVersion());
    }

    public static ModuleVersionIdentifier newId(String group, String name, String version) {
        return new DefaultModuleVersionIdentifier(group, name, version);
    }
}

