/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.Contextual;
import org.gradle.api.internal.MultiCauseException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationAwareException
extends GradleException {
    private final Throwable target;
    private final ScriptSource source;
    private final Integer lineNumber;

    public LocationAwareException(Throwable cause, Throwable target, ScriptSource source, Integer lineNumber) {
        this.source = source;
        this.lineNumber = lineNumber;
        this.target = target;
        this.initCause(cause);
    }

    public Throwable getTarget() {
        return this.target;
    }

    public String getOriginalMessage() {
        return this.target.getMessage();
    }

    public ScriptSource getScriptSource() {
        return this.source;
    }

    public String getLocation() {
        if (this.source == null) {
            return null;
        }
        String sourceMsg = StringUtils.capitalize((String)this.source.getDisplayName());
        if (this.lineNumber == null) {
            return sourceMsg;
        }
        return String.format("%s line: %d", sourceMsg, this.lineNumber);
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        String location = this.getLocation();
        String message = this.target.getMessage();
        if (location == null && message == null) {
            return null;
        }
        if (location == null) {
            return message;
        }
        if (message == null) {
            return location;
        }
        return String.format("%s%n%s", location, message);
    }

    public List<Throwable> getReportableCauses() {
        final ArrayList<Throwable> causes = new ArrayList<Throwable>();
        this.visitCauses(this.target, (TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){

            @Override
            public void node(Throwable node) {
                causes.add(node);
            }
        });
        return causes;
    }

    public void visitReportableCauses(TreeVisitor<? super Throwable> visitor) {
        visitor.node(this);
        this.visitCauses(this.target, visitor);
    }

    private void visitCauses(Throwable t, TreeVisitor<? super Throwable> visitor) {
        if (t instanceof MultiCauseException) {
            MultiCauseException multiCauseException = (MultiCauseException)((Object)t);
            List<? extends Throwable> causes = multiCauseException.getCauses();
            if (!causes.isEmpty()) {
                visitor.startChildren();
                for (Throwable throwable : causes) {
                    visitor.node(throwable);
                    if (throwable.getClass().getAnnotation(Contextual.class) == null) continue;
                    this.visitCauses(throwable, visitor);
                }
                visitor.endChildren();
            }
        } else if (t.getCause() != null) {
            visitor.startChildren();
            Throwable cause = t.getCause();
            visitor.node(cause);
            if (cause.getClass().getAnnotation(Contextual.class) != null) {
                this.visitCauses(cause, visitor);
            }
            visitor.endChildren();
        }
    }
}

