/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class TaskExecutionLogger
implements TaskExecutionListener {
    private final Map<Task, ProgressLogger> currentTasks = new HashMap<Task, ProgressLogger>();
    private final ProgressLoggerFactory progressLoggerFactory;

    public TaskExecutionLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void beforeExecute(Task task) {
        assert (!this.currentTasks.containsKey(task));
        ProgressLogger currentTask = this.progressLoggerFactory.newOperation(TaskExecutionLogger.class);
        String displayName = this.getDisplayName(task);
        currentTask.setDescription(String.format("Execute %s", displayName));
        currentTask.setShortDescription(displayName);
        currentTask.setLoggingHeader(displayName);
        currentTask.started();
        this.currentTasks.put(task, currentTask);
    }

    public void afterExecute(Task task, TaskState state) {
        ProgressLogger currentTask = this.currentTasks.remove(task);
        String taskMessage = state.getFailure() != null ? "FAILED" : state.getSkipMessage();
        currentTask.completed(taskMessage);
    }

    private String getDisplayName(Task task) {
        Gradle build = task.getProject().getGradle();
        if (build.getParent() == null) {
            return task.getPath();
        }
        return ":" + build.getRootProject().getName() + task.getPath();
    }
}

