/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber UNKNOWN = new VersionNumber(0, 0, 0, null);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))?+(?:\\.(\\d+))?+(?:[-\\.](.+))?");
    private static final String VERSION_TEMPLATE = "%d.%d.%d%s";
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public VersionNumber(int major, int minor, int micro, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public VersionNumber getBaseVersion() {
        return new VersionNumber(this.major, this.minor, this.micro, null);
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        return Ordering.natural().nullsLast().compare((Object)this.toLowerCase(this.qualifier), (Object)this.toLowerCase(other.qualifier));
    }

    public boolean equals(Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.qualifier});
        return result;
    }

    public String toString() {
        return String.format(VERSION_TEMPLATE, this.major, this.minor, this.micro, this.qualifier == null ? "" : "-" + this.qualifier);
    }

    public static VersionNumber parse(String versionString) {
        if (versionString == null) {
            return UNKNOWN;
        }
        Matcher m = VERSION_PATTERN.matcher(versionString);
        if (!m.matches()) {
            return UNKNOWN;
        }
        int major = Integer.valueOf(m.group(1));
        String minorString = m.group(2);
        int minor = minorString == null ? 0 : Integer.valueOf(minorString);
        String microString = m.group(3);
        int micro = microString == null ? 0 : Integer.valueOf(microString);
        String qualifier = m.group(4);
        return new VersionNumber(major, minor, micro, qualifier);
    }

    private String toLowerCase(@Nullable String string) {
        return string == null ? null : string.toLowerCase();
    }
}

