/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import org.gradle.api.Plugin;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.resolve.internal.InvalidPluginRequestException;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolution;
import org.gradle.plugin.resolve.internal.PluginResolver;
import org.gradle.plugin.resolve.internal.SimplePluginResolution;

public class PluginRegistryPluginResolver
implements PluginResolver {
    private final DocumentationRegistry documentationRegistry;
    private final PluginRegistry pluginRegistry;

    public PluginRegistryPluginResolver(DocumentationRegistry documentationRegistry, PluginRegistry pluginRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.pluginRegistry = pluginRegistry;
    }

    public PluginResolution resolve(PluginRequest pluginRequest) {
        try {
            Class<? extends Plugin> typeForId = this.pluginRegistry.getTypeForId(pluginRequest.getId());
            if (pluginRequest.getVersion() != null) {
                throw new InvalidPluginRequestException("Plugin '" + pluginRequest.getId() + "' is a core Gradle plugin, which cannot be specified with a version number. " + "Such plugins are versioned as part of Gradle. Please remove the version number from the declaration.");
            }
            return new SimplePluginResolution(typeForId);
        }
        catch (UnknownPluginException e) {
            return null;
        }
    }

    public String toString() {
        return "PluginRegistryPluginResolver[" + this.pluginRegistry + "]";
    }

    public String getDescriptionForNotFoundMessage() {
        return String.format("Gradle Distribution Plugins (listing: %s)", this.documentationRegistry.getDocumentationFor("standard_plugins"));
    }
}

