/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.resolve.internal.InvalidPluginRequestException;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolution;
import org.gradle.plugin.resolve.internal.PluginResolver;

public class NotInPluginRegistryPluginResolverCheck
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginRegistry corePluginRegistry;
    private final PluginDescriptorLocator pluginDescriptorLocator;

    public NotInPluginRegistryPluginResolverCheck(PluginResolver delegate, PluginRegistry corePluginRegistry, PluginDescriptorLocator pluginDescriptorLocator) {
        this.delegate = delegate;
        this.corePluginRegistry = corePluginRegistry;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
    }

    public PluginResolution resolve(PluginRequest pluginRequest) {
        String pluginId = pluginRequest.getId();
        PluginDescriptor pluginDescriptor = this.pluginDescriptorLocator.findPluginDescriptor(pluginId);
        if (pluginDescriptor == null || this.isCorePlugin(pluginId)) {
            return this.delegate.resolve(pluginRequest);
        }
        throw new InvalidPluginRequestException(String.format("Plugin '%s' is already on the script classpath (plugins on the script classpath cannot be used in a plugins {} block; move \"apply plugin: '%s'\" outside of the plugins {} block)", pluginId, pluginId));
    }

    private boolean isCorePlugin(String pluginId) {
        try {
            this.corePluginRegistry.getTypeForId(pluginId);
            return true;
        }
        catch (UnknownPluginException ignore) {
            return false;
        }
    }

    public String getDescriptionForNotFoundMessage() {
        return this.delegate.getDescriptionForNotFoundMessage();
    }
}

