/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import com.jfrog.bintray.client.api.handle.Bintray;
import com.jfrog.bintray.client.api.model.Pkg;
import com.jfrog.bintray.client.impl.BintrayClient;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Supplier;
import org.gradle.plugin.resolve.internal.InvalidPluginRequestException;
import org.gradle.plugin.resolve.internal.ModuleMappingPluginResolver;
import org.gradle.plugin.resolve.internal.PluginRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCenterPluginMapper
implements ModuleMappingPluginResolver.Mapper {
    public static final String BINTRAY_API_OVERRIDE_URL_PROPERTY = JCenterPluginMapper.class.getName() + ".bintray.override";
    public static final String GRADLE_PLUGINS_ORG = "gradle-plugins-development";
    public static final String GRADLE_PLUGINS_REPO = "gradle-plugins";
    public static final String PLUGIN_ID_ATTRIBUTE_NAME = "gradle-plugin-id";
    private static final String NOT_FOUND = "";
    private final Supplier<PersistentIndexedCache<PluginRequest, String>> cacheSupplier;

    public JCenterPluginMapper(Supplier<PersistentIndexedCache<PluginRequest, String>> cacheSupplier) {
        this.cacheSupplier = cacheSupplier;
    }

    @Override
    public Dependency map(final PluginRequest request, DependencyHandler dependencyHandler) {
        final String pluginId = request.getId();
        String systemId = (String)this.cacheSupplier.supplyTo((Transformer)new Transformer<String, PersistentIndexedCache<PluginRequest, String>>(){

            public String transform(PersistentIndexedCache<PluginRequest, String> cache) {
                return JCenterPluginMapper.this.doCacheAwareSearch(request, pluginId, cache);
            }
        });
        if (systemId.equals(NOT_FOUND)) {
            return null;
        }
        return dependencyHandler.create(systemId + ":" + request.getVersion());
    }

    private String doCacheAwareSearch(PluginRequest request, String pluginId, PersistentIndexedCache<PluginRequest, String> indexedCache) {
        String systemId;
        String cached = indexedCache.get(request);
        if (cached != null) {
            return cached;
        }
        Bintray bintrayClient = this.createBintrayClient();
        List results = bintrayClient.subject(GRADLE_PLUGINS_ORG).repository(GRADLE_PLUGINS_REPO).searchForPackage().byAttributeName(PLUGIN_ID_ATTRIBUTE_NAME).equals(pluginId).search();
        if (results.isEmpty()) {
            systemId = NOT_FOUND;
        } else {
            if (request.getVersion() == null) {
                throw new InvalidPluginRequestException(String.format("No version number supplied for plugin '%s'. A version number must be supplied for plugins resolved from '%s'.", pluginId, this.getBintrayRepoUrl()));
            }
            if (results.size() > 1) {
                throw new InvalidPluginRequestException("Found more than one plugin for plugin id " + pluginId);
            }
            Pkg pluginPackage = (Pkg)results.get(0);
            List systemIds = pluginPackage.systemIds();
            if (systemIds.isEmpty()) {
                throw new InvalidPluginRequestException("No artifacts in maven layout found for plugin id" + pluginId);
            }
            systemId = (String)systemIds.get(0);
        }
        indexedCache.put(request, systemId);
        return systemId;
    }

    private Bintray createBintrayClient() {
        String override = System.getProperty(BINTRAY_API_OVERRIDE_URL_PROPERTY);
        if (override == null) {
            return BintrayClient.create();
        }
        return BintrayClient.create((String)override, null, null);
    }

    public String getBintrayRepoUrl() {
        return String.format("https://bintray.com/%s/%s", GRADLE_PLUGINS_ORG, GRADLE_PLUGINS_REPO);
    }
}

