/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import java.util.Iterator;
import java.util.List;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolution;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePluginResolver
implements PluginResolver {
    private final List<PluginResolver> repositories;

    public CompositePluginResolver(List<PluginResolver> repositories) {
        this.repositories = repositories;
    }

    @Override
    public PluginResolution resolve(PluginRequest pluginRequest) {
        PluginResolver repository;
        PluginResolution resolution = null;
        Iterator<PluginResolver> i$ = this.repositories.iterator();
        while (i$.hasNext() && (resolution = (repository = i$.next()).resolve(pluginRequest)) == null) {
        }
        return resolution;
    }

    @Override
    public String getDescriptionForNotFoundMessage() {
        StringBuilder sb = new StringBuilder("plugin repositories:");
        for (PluginResolver repository : this.repositories) {
            sb.append("\n - ").append(repository.getDescriptionForNotFoundMessage());
        }
        return sb.toString();
    }
}

