/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.cache.CacheRepository;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.internal.PluginResolvers;
import org.gradle.plugin.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.resolve.internal.NotInPluginRegistryPluginResolverCheck;
import org.gradle.plugin.resolve.internal.PluginRegistryPluginResolver;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResolverFactory {
    private final PluginRegistry pluginRegistry;
    private final Instantiator instantiator;
    private final DependencyManagementServices dependencyManagementServices;
    private final FileResolver fileResolver;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final DocumentationRegistry documentationRegistry;
    private final CacheRepository cacheRepository;
    private final ProjectFinder projectFinder = new ProjectFinder(){

        public ProjectInternal getProject(String path) {
            throw new UnknownProjectException("Cannot use project dependencies in a plugin resolution definition.");
        }
    };

    public PluginResolverFactory(PluginRegistry pluginRegistry, Instantiator instantiator, DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, DependencyMetaDataProvider dependencyMetaDataProvider, DocumentationRegistry documentationRegistry, CacheRepository cacheRepository) {
        this.pluginRegistry = pluginRegistry;
        this.instantiator = instantiator;
        this.dependencyManagementServices = dependencyManagementServices;
        this.fileResolver = fileResolver;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.documentationRegistry = documentationRegistry;
        this.cacheRepository = cacheRepository;
    }

    public PluginResolver createPluginResolver(ClassLoader scriptClassLoader) {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(resolvers);
        CompositePluginResolver compositePluginResolver = new CompositePluginResolver(resolvers);
        ClassloaderBackedPluginDescriptorLocator scriptClasspathPluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(scriptClassLoader);
        NotInPluginRegistryPluginResolverCheck notAlreadyOnClasspathCheck = new NotInPluginRegistryPluginResolverCheck(compositePluginResolver, this.pluginRegistry, scriptClasspathPluginDescriptorLocator);
        return notAlreadyOnClasspathCheck;
    }

    private void addDefaultResolvers(List<PluginResolver> resolvers) {
        resolvers.add(new PluginRegistryPluginResolver(this.documentationRegistry, this.pluginRegistry));
        resolvers.add(PluginResolvers.jcenterGradleOfficial(this.instantiator, this.createDependencyResolutionServices(), this.cacheRepository));
    }

    private DependencyResolutionServices createDependencyResolutionServices() {
        return this.dependencyManagementServices.create(this.fileResolver, this.dependencyMetaDataProvider, this.projectFinder, new BasicDomainObjectContext());
    }

    private static class BasicDomainObjectContext
    implements DomainObjectContext {
        private BasicDomainObjectContext() {
        }

        public String absoluteProjectPath(String name) {
            return name;
        }
    }
}

