/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.internal;

import org.gradle.api.Action;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolution;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRequestApplicator {
    private final PluginResolver pluginResolver;
    private final Action<? super PluginResolution> pluginResolutionHandler;

    public PluginRequestApplicator(PluginResolver pluginResolver, Action<? super PluginResolution> pluginResolutionHandler) {
        this.pluginResolver = pluginResolver;
        this.pluginResolutionHandler = pluginResolutionHandler;
    }

    public void applyPlugin(Iterable<? extends PluginRequest> requests) {
        for (PluginRequest pluginRequest : requests) {
            this.applyPlugin(pluginRequest);
        }
    }

    public void applyPlugin(PluginRequest request) {
        PluginResolution resolution = this.pluginResolver.resolve(request);
        if (resolution == null) {
            throw new UnknownPluginException("Cannot resolve plugin request " + request + " from " + this.pluginResolver.getDescriptionForNotFoundMessage());
        }
        this.pluginResolutionHandler.execute((Object)resolution);
    }
}

