/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.FilterReply;
import java.io.PrintStream;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.UncheckedException;
import org.gradle.logging.internal.LogEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.logback.LogLevelConverter;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LogbackLoggingConfigurer
implements LoggingConfigurer {
    private final OutputEventListener outputEventListener;
    private final PrintStream defaultStandardOut = System.out;
    private LogLevel currentLevel;

    public LogbackLoggingConfigurer(OutputEventListener outputListener) {
        this.outputEventListener = outputListener;
    }

    public void configure(LogLevel logLevel) {
        if (logLevel == this.currentLevel) {
            return;
        }
        try {
            this.doConfigure(logLevel);
        }
        catch (Throwable e) {
            this.doFailSafeConfiguration();
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void doConfigure(LogLevel logLevel) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = context.getLogger("ROOT");
        if (this.currentLevel == null) {
            context.reset();
            context.addTurboFilter((TurboFilter)new GradleFilter());
            context.getLogger("org.apache.http.wire").setLevel(Level.OFF);
            GradleAppender appender = new GradleAppender();
            appender.setContext((Context)context);
            appender.start();
            rootLogger.addAppender((Appender)appender);
        }
        this.currentLevel = logLevel;
        rootLogger.setLevel(LogLevelConverter.toLogbackLevel(logLevel));
    }

    private void doFailSafeConfiguration() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        Logger rootLogger = context.getLogger("ROOT");
        rootLogger.setLevel(Level.INFO);
        ConsoleAppender appender = new ConsoleAppender();
        rootLogger.addAppender((Appender)appender);
        appender.setContext((Context)context);
        appender.setTarget("System.err");
        PatternLayout layout = new PatternLayout();
        appender.setLayout((Layout)layout);
        layout.setPattern("%msg%n%ex");
        layout.setContext((Context)context);
        layout.start();
        appender.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GradleAppender
    extends AppenderBase<ILoggingEvent> {
        private GradleAppender() {
        }

        protected void append(ILoggingEvent event) {
            try {
                ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
                Throwable throwable = throwableProxy == null ? null : throwableProxy.getThrowable();
                String message = event.getFormattedMessage();
                LogLevel level = LogLevelConverter.toGradleLogLevel(event.getLevel(), event.getMarker());
                LogbackLoggingConfigurer.this.outputEventListener.onOutput(new LogEvent(event.getTimeStamp(), event.getLoggerName(), level, message, throwable));
            }
            catch (Throwable t) {
                t.printStackTrace(LogbackLoggingConfigurer.this.defaultStandardOut);
            }
        }
    }

    private class GradleFilter
    extends TurboFilter {
        private GradleFilter() {
        }

        public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
            Level loggerLevel = logger.getEffectiveLevel();
            if (loggerLevel == Level.INFO && (level == Level.INFO || level == Level.WARN) || level == Level.INFO && (loggerLevel == Level.INFO || loggerLevel == Level.WARN)) {
                LogLevel eventLevel = LogLevelConverter.toGradleLogLevel(level, marker);
                return eventLevel.compareTo(LogbackLoggingConfigurer.this.currentLevel) >= 0 ? FilterReply.ACCEPT : FilterReply.DENY;
            }
            return level.isGreaterOrEqual(loggerLevel) ? FilterReply.ACCEPT : FilterReply.DENY;
        }
    }
}

