/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Collections;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.SettingsFactory;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsScript;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatingSettingsProcessor
implements SettingsProcessor {
    private static Logger logger = LoggerFactory.getLogger(ScriptEvaluatingSettingsProcessor.class);
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final SettingsFactory settingsFactory;
    private final IGradlePropertiesLoader propertiesLoader;
    private final ScriptPluginFactory configurerFactory;

    public ScriptEvaluatingSettingsProcessor(ScriptPluginFactory configurerFactory, ScriptHandlerFactory scriptHandlerFactory, SettingsFactory settingsFactory, IGradlePropertiesLoader propertiesLoader) {
        this.configurerFactory = configurerFactory;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.settingsFactory = settingsFactory;
        this.propertiesLoader = propertiesLoader;
    }

    public SettingsInternal process(GradleInternal gradle, SettingsLocation settingsLocation, ClassLoaderScope classLoaderScope, StartParameter startParameter) {
        Clock settingsProcessingClock = new Clock();
        Map<String, String> properties = this.propertiesLoader.mergeProperties(Collections.<String, String>emptyMap());
        SettingsInternal settings = this.settingsFactory.createSettings(gradle, settingsLocation.getSettingsDir(), settingsLocation.getSettingsScriptSource(), properties, startParameter, classLoaderScope);
        this.applySettingsScript(settingsLocation, settings);
        logger.debug("Timing: Processing settings took: {}", (Object)settingsProcessingClock.getTime());
        return settings;
    }

    private void applySettingsScript(SettingsLocation settingsLocation, SettingsInternal settings) {
        ScriptSource settingsScriptSource = settingsLocation.getSettingsScriptSource();
        ClassLoaderScope classLoaderScope = settings.getClassLoaderScope();
        ScriptHandler scriptHandler = this.scriptHandlerFactory.create(settingsScriptSource, classLoaderScope);
        ScriptPlugin configurer = this.configurerFactory.create(settingsScriptSource, scriptHandler, classLoaderScope, "buildscript", SettingsScript.class);
        configurer.apply(settings);
    }
}

