/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropertySettingBuildLoader
implements BuildLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectPropertySettingBuildLoader.class);
    private final IGradlePropertiesLoader propertiesLoader;
    private final BuildLoader buildLoader;

    public ProjectPropertySettingBuildLoader(IGradlePropertiesLoader propertiesLoader, BuildLoader buildLoader) {
        this.buildLoader = buildLoader;
        this.propertiesLoader = propertiesLoader;
    }

    public void load(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle, ClassLoaderScope classLoaderScope) {
        this.buildLoader.load(rootProjectDescriptor, gradle, classLoaderScope);
        this.setProjectProperties(gradle.getRootProject());
    }

    private void setProjectProperties(Project project) {
        this.addPropertiesToProject(project);
        for (Project childProject : project.getChildProjects().values()) {
            this.setProjectProperties(childProject);
        }
    }

    private void addPropertiesToProject(Project project) {
        Properties projectProperties = new Properties();
        File projectPropertiesFile = new File(project.getProjectDir(), "gradle.properties");
        LOGGER.debug("Looking for project properties from: {}", (Object)projectPropertiesFile);
        if (projectPropertiesFile.isFile()) {
            projectProperties = GUtil.loadProperties(projectPropertiesFile);
            LOGGER.debug("Adding project properties (if not overwritten by user properties): {}", projectProperties.keySet());
        } else {
            LOGGER.debug("project property file does not exists. We continue!");
        }
        Map<String, String> mergedProperties = this.propertiesLoader.mergeProperties(new HashMap<Object, Object>(projectProperties));
        ExtraPropertiesExtension extraProperties = new DslObject(project).getExtensions().getExtraProperties();
        for (Map.Entry<String, String> entry : mergedProperties.entrySet()) {
            if (project.hasProperty(entry.getKey())) {
                project.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            extraProperties.set(entry.getKey(), entry.getValue());
        }
    }
}

