/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.initialization.AbstractProjectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPathProjectSpec
extends AbstractProjectSpec
implements Serializable {
    private final String projectPath;

    public ProjectPathProjectSpec(String projectPath) {
        this.projectPath = projectPath;
    }

    @Override
    public String getDisplayName() {
        return String.format("project has path '%s'", this.projectPath);
    }

    @Override
    protected String formatNoMatchesMessage() {
        return String.format("No projects in this build have path '%s'.", this.projectPath);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> matches) {
        return String.format("Multiple projects in this build have path '%s': %s", this.projectPath, matches);
    }

    @Override
    protected boolean select(ProjectIdentifier project) {
        return this.projectPath.equals(project.getPath());
    }

    @Override
    protected void checkPreconditions(ProjectRegistry<?> registry) {
        if (Strings.isNullOrEmpty((String)this.projectPath)) {
            throw new InvalidUserDataException("Project path must not be empty.");
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

