/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Arrays;
import org.gradle.BuildAdapter;
import org.gradle.BuildLogger;
import org.gradle.BuildResult;
import org.gradle.GradleLauncher;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionLogger;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.cache.CacheRepository;
import org.gradle.cli.CommandLineConverter;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.DefaultSettingsFinder;
import org.gradle.initialization.DependencyResolutionLogger;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.NestedBuildTracker;
import org.gradle.initialization.SettingsHandler;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.TasksCompletionListener;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.progress.BuildProgressFilter;
import org.gradle.internal.progress.BuildProgressLogger;
import org.gradle.internal.progress.LoggerProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.profile.ProfileEventAdapter;
import org.gradle.profile.ReportGeneratingProfileListener;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final ServiceRegistry sharedServices;
    private final NestedBuildTracker tracker;
    private final BuildProgressLogger buildProgressLogger;
    private CommandLineConverter<StartParameter> commandLineConverter;

    public DefaultGradleLauncherFactory(ServiceRegistry globalServices) {
        this.sharedServices = globalServices;
        this.tracker = new NestedBuildTracker();
        ListenerManager listenerManager = (ListenerManager)this.sharedServices.get(ListenerManager.class);
        this.buildProgressLogger = new BuildProgressLogger((ProgressLoggerFactory)this.sharedServices.get(ProgressLoggerFactory.class));
        listenerManager.addListener(new BuildProgressFilter(this.buildProgressLogger));
        listenerManager.useLogger(new DependencyResolutionLogger((ProgressLoggerFactory)this.sharedServices.get(ProgressLoggerFactory.class)));
        GradleLauncher.injectCustomFactory(this);
    }

    public void addListener(Object listener) {
        ((ListenerManager)this.sharedServices.get(ListenerManager.class)).addListener(listener);
    }

    public void removeListener(Object listener) {
        ((ListenerManager)this.sharedServices.get(ListenerManager.class)).removeListener(listener);
    }

    @Override
    public StartParameter createStartParameter(String ... commandLineArgs) {
        if (this.commandLineConverter == null) {
            this.commandLineConverter = (CommandLineConverter)this.sharedServices.get(CommandLineConverter.class);
        }
        return (StartParameter)this.commandLineConverter.convert(Arrays.asList(commandLineArgs));
    }

    @Override
    public DefaultGradleLauncher newInstance(StartParameter startParameter) {
        DefaultBuildRequestMetaData requestMetaData = this.tracker.getCurrentBuild() != null ? new DefaultBuildRequestMetaData((BuildClientMetaData)this.tracker.getCurrentBuild().getServices().get(BuildClientMetaData.class), System.currentTimeMillis()) : new DefaultBuildRequestMetaData(System.currentTimeMillis());
        return this.doNewInstance(startParameter, requestMetaData);
    }

    @Override
    public DefaultGradleLauncher newInstance(StartParameter startParameter, BuildRequestMetaData requestMetaData) {
        assert (this.tracker.getCurrentBuild() == null);
        return this.doNewInstance(startParameter, requestMetaData);
    }

    private DefaultGradleLauncher doNewInstance(StartParameter startParameter, BuildRequestMetaData requestMetaData) {
        BuildScopeServices serviceRegistry = new BuildScopeServices(this.sharedServices, startParameter);
        serviceRegistry.add(BuildRequestMetaData.class, requestMetaData);
        serviceRegistry.add(BuildClientMetaData.class, requestMetaData.getClient());
        ListenerManager listenerManager = (ListenerManager)serviceRegistry.get(ListenerManager.class);
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)serviceRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.setLevel(startParameter.getLogLevel());
        loggingManager.addStandardOutputListener(listenerManager.getBroadcaster(StandardOutputListener.class));
        loggingManager.addStandardErrorListener(listenerManager.getBroadcaster(StandardOutputListener.class));
        LoggerProvider loggerProvider = this.tracker.getCurrentBuild() == null ? this.buildProgressLogger : LoggerProvider.NO_OP;
        listenerManager.useLogger(new TaskExecutionLogger((ProgressLoggerFactory)serviceRegistry.get(ProgressLoggerFactory.class), loggerProvider));
        if (this.tracker.getCurrentBuild() == null) {
            listenerManager.useLogger(new BuildLogger(Logging.getLogger(BuildLogger.class), (StyledTextOutputFactory)serviceRegistry.get(StyledTextOutputFactory.class), startParameter, requestMetaData));
        }
        listenerManager.addListener(this.tracker);
        listenerManager.addListener(new BuildCleanupListener(serviceRegistry));
        listenerManager.addListener(serviceRegistry.get(ProfileEventAdapter.class));
        if (startParameter.isProfile()) {
            listenerManager.addListener(new ReportGeneratingProfileListener());
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener(usageLocationReporter);
        DeprecationLogger.useLocationReporter(usageLocationReporter);
        GradleInternal gradle = (GradleInternal)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultGradle.class, new Object[]{this.tracker.getCurrentBuild(), startParameter, serviceRegistry.get(ServiceRegistryFactory.class)});
        return new DefaultGradleLauncher(gradle, (InitScriptHandler)serviceRegistry.get(InitScriptHandler.class), new SettingsHandler(new DefaultSettingsFinder(new BuildLayoutFactory()), (SettingsProcessor)serviceRegistry.get(SettingsProcessor.class), new BuildSourceBuilder(this, (ClassLoaderScope)serviceRegistry.get(ClassLoaderScope.class), (CacheRepository)serviceRegistry.get(CacheRepository.class))), (BuildLoader)serviceRegistry.get(BuildLoader.class), (BuildConfigurer)serviceRegistry.get(BuildConfigurer.class), gradle.getBuildListenerBroadcaster(), (ExceptionAnalyser)serviceRegistry.get(ExceptionAnalyser.class), loggingManager, listenerManager.getBroadcaster(ModelConfigurationListener.class), listenerManager.getBroadcaster(TasksCompletionListener.class), (BuildExecuter)gradle.getServices().get(BuildExecuter.class));
    }

    public void setCommandLineConverter(CommandLineConverter<StartParameter> commandLineConverter) {
        this.commandLineConverter = commandLineConverter;
    }

    private static class BuildCleanupListener
    extends BuildAdapter {
        private final BuildScopeServices services;

        private BuildCleanupListener(BuildScopeServices services) {
            this.services = services;
        }

        public void buildFinished(BuildResult result) {
            this.services.close();
        }
    }
}

