/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.gradle.api.Transformer;
import org.gradle.groovy.scripts.internal.ScriptBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBlockToServiceConfigurationTransformer
implements Transformer<Statement, ScriptBlock> {
    private final String servicesFieldName;
    private final Class<?> serviceClass;

    public ScriptBlockToServiceConfigurationTransformer(String servicesFieldName, Class<?> serviceClass) {
        this.servicesFieldName = servicesFieldName;
        this.serviceClass = serviceClass;
    }

    public Statement transform(ScriptBlock scriptBlock) {
        ClosureExpression closureArg = scriptBlock.getClosureExpression();
        PropertyExpression servicesProperty = new PropertyExpression((Expression)VariableExpression.THIS_EXPRESSION, this.servicesFieldName);
        MethodCallExpression getServiceMethodCall = new MethodCallExpression((Expression)servicesProperty, "get", (Expression)new ArgumentListExpression((Expression)new ClassExpression(new ClassNode(this.serviceClass))));
        MethodCallExpression hydrateMethodCall = new MethodCallExpression((Expression)closureArg, "rehydrate", (Expression)new ArgumentListExpression((Expression)ConstantExpression.NULL, (Expression)getServiceMethodCall, (Expression)getServiceMethodCall));
        MethodCallExpression closureCall = new MethodCallExpression((Expression)hydrateMethodCall, "call", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
        return new ExpressionStatement((Expression)closureCall);
    }
}

