/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.execution.TaskSelector;
import org.gradle.execution.commandline.CommandLineTaskConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineTaskParser {
    private final CommandLineTaskConfigurer taskConfigurer;

    public CommandLineTaskParser(CommandLineTaskConfigurer commandLineTaskConfigurer) {
        this.taskConfigurer = commandLineTaskConfigurer;
    }

    public Multimap<String, Task> parseTasks(List<String> taskPaths, TaskSelector taskSelector) {
        LinkedHashMultimap out = LinkedHashMultimap.create();
        List<String> remainingPaths = new LinkedList<String>(taskPaths);
        while (!remainingPaths.isEmpty()) {
            String path = (String)remainingPaths.remove(0);
            TaskSelector.TaskSelection selection = taskSelector.getSelection(path);
            Set<Task> tasks = selection.getTasks();
            remainingPaths = this.taskConfigurer.configureTasks(tasks, remainingPaths);
            out.putAll((Object)selection.getTaskName(), tasks);
        }
        return out;
    }
}

