/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskSelector;

public class ExcludedTaskFilteringBuildConfigurationAction
implements BuildConfigurationAction {
    public void configure(BuildExecutionContext context) {
        GradleInternal gradle = context.getGradle();
        Set<String> excludedTaskNames = gradle.getStartParameter().getExcludedTaskNames();
        if (!excludedTaskNames.isEmpty()) {
            TaskSelector selector = (TaskSelector)gradle.getServices().get(TaskSelector.class);
            final HashSet<Task> excludedTasks = new HashSet<Task>();
            for (String taskName : excludedTaskNames) {
                excludedTasks.addAll(selector.getSelection(taskName).getTasks());
            }
            gradle.getTaskGraph().useFilter((Spec<? super Task>)new Spec<Task>(){

                public boolean isSatisfiedBy(Task task) {
                    return !excludedTasks.contains(task);
                }
            });
        }
        context.proceed();
    }
}

