/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.project.ProjectConfigureAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDependencies2TaskResolver
implements ProjectConfigureAction {
    private static Logger logger = LoggerFactory.getLogger(ProjectDependencies2TaskResolver.class);

    public void execute(ProjectInternal project) {
        for (Project dependsOnProject : project.getDependsOnProjects()) {
            logger.debug("Checking task dependencies for project: {} dependsOn: {}", (Object)project, (Object)dependsOnProject);
            for (Task task : project.getTasks()) {
                String taskName = task.getName();
                Task dependentTask = (Task)dependsOnProject.getTasks().findByName(taskName);
                if (dependentTask == null) continue;
                logger.debug("Setting task dependencies for task: {}", (Object)taskName);
                task.dependsOn(dependentTask);
            }
        }
    }
}

