/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.plugins.PluginAware;
import org.gradle.configuration.ImportsReader;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.ScriptAware;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.groovy.scripts.internal.PluginsAndBuildscriptTransformer;
import org.gradle.groovy.scripts.internal.StatementExtractingScriptTransformer;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.plugin.PluginHandler;
import org.gradle.plugin.internal.DefaultPluginHandler;
import org.gradle.plugin.internal.NonPluggableTargetPluginHandler;
import org.gradle.plugin.internal.PluginRequestApplicator;
import org.gradle.plugin.internal.PluginResolutionApplicator;
import org.gradle.plugin.internal.PluginResolverFactory;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final ImportsReader importsReader;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final PluginResolverFactory pluginResolverFactory;
    private final FileLookup fileLookup;

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, ImportsReader importsReader, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator, ScriptHandlerFactory scriptHandlerFactory, PluginResolverFactory pluginResolverFactory, FileLookup fileLookup) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.importsReader = importsReader;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.pluginResolverFactory = pluginResolverFactory;
        this.fileLookup = fileLookup;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope, String classpathClosureName, Class<? extends BasicScript> scriptClass) {
        return new ScriptPluginImpl(scriptSource, scriptHandler, classLoaderScope, classpathClosureName, scriptClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private final ClassLoaderScope classLoaderScope;
        private final String classpathClosureName;
        private final Class<? extends BasicScript> scriptType;
        private final ScriptHandler scriptHandler;

        public ScriptPluginImpl(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope, String classpathClosureName, Class<? extends BasicScript> scriptType) {
            this.scriptSource = scriptSource;
            this.classLoaderScope = classLoaderScope;
            this.classpathClosureName = classpathClosureName;
            this.scriptHandler = scriptHandler;
            this.scriptType = scriptType;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public void apply(Object target) {
            DefaultServiceRegistry services = new DefaultServiceRegistry();
            services.add(ScriptPluginFactory.class, (Object)DefaultScriptPluginFactory.this);
            services.add(ScriptHandlerFactory.class, (Object)DefaultScriptPluginFactory.this.scriptHandlerFactory);
            services.add(ClassLoaderScope.class, (Object)this.classLoaderScope);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, (Object)DefaultScriptPluginFactory.this.instantiator);
            services.add(ScriptHandler.class, (Object)this.scriptHandler);
            services.add(FileLookup.class, (Object)DefaultScriptPluginFactory.this.fileLookup);
            ScriptSource withImports = DefaultScriptPluginFactory.this.importsReader.withImports(this.scriptSource);
            LinkedList<PluginRequest> pluginRequests = new LinkedList<PluginRequest>();
            if (target instanceof PluginAware) {
                services.add(PluginHandler.class, (Object)new DefaultPluginHandler(pluginRequests));
            } else {
                services.add(PluginHandler.class, (Object)new NonPluggableTargetPluginHandler(target));
            }
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(withImports);
            compiler.setClassloader(this.classLoaderScope.getBase().getChildClassLoader());
            PluginsAndBuildscriptTransformer scriptBlockTransformer = new PluginsAndBuildscriptTransformer(this.classpathClosureName);
            StatementExtractingScriptTransformer classpathScriptTransformer = new StatementExtractingScriptTransformer(this.classpathClosureName, scriptBlockTransformer);
            compiler.setTransformer(classpathScriptTransformer);
            ScriptRunner<? extends BasicScript> classPathScriptRunner = compiler.compile(this.scriptType);
            classPathScriptRunner.getScript().init(target, (ServiceRegistry)services);
            classPathScriptRunner.run();
            Configuration classpathConfiguration = this.scriptHandler.getConfigurations().getByName("classpath");
            Set<File> files = classpathConfiguration.getFiles();
            DefaultClassPath classPath = new DefaultClassPath(files);
            ClassLoader exportedClassLoader = this.classLoaderScope.export((ClassPath)classPath);
            if (!pluginRequests.isEmpty()) {
                PluginResolver pluginResolver = DefaultScriptPluginFactory.this.pluginResolverFactory.createPluginResolver(exportedClassLoader);
                PluginResolutionApplicator resolutionApplicator = new PluginResolutionApplicator((PluginAware)target, this.classLoaderScope);
                PluginRequestApplicator requestApplicator = new PluginRequestApplicator(pluginResolver, resolutionApplicator);
                requestApplicator.applyPlugin(pluginRequests);
            }
            this.classLoaderScope.lock();
            compiler.setClassloader(this.classLoaderScope.getScopeClassLoader());
            compiler.setTransformer(new BuildScriptTransformer("no_" + classpathScriptTransformer.getId(), classpathScriptTransformer.invert()));
            ScriptRunner<? extends BasicScript> runner = compiler.compile(this.scriptType);
            BasicScript script = runner.getScript();
            script.init(target, (ServiceRegistry)services);
            if (target instanceof ScriptAware) {
                ((ScriptAware)target).setScript(script);
            }
            runner.run();
        }
    }
}

