/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.gradle.cache.internal.GracefullyStoppedException;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;

public class FileLockCommunicator {
    private static final byte PROTOCOL_VERSION = 1;
    private final DatagramSocket socket;
    private final InetAddressFactory addressFactory;
    private boolean stopped;

    public FileLockCommunicator(InetAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void pingOwner(int ownerPort, long lockId, String displayName) {
        try {
            byte[] bytesToSend = FileLockCommunicator.encode(lockId);
            for (InetAddress address : this.addressFactory.findLocalAddresses()) {
                this.socket.send(new DatagramPacket(bytesToSend, bytesToSend.length, address, ownerPort));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to ping owner of lock for %s (lock id: %s, port: %s)", displayName, lockId, ownerPort), e);
        }
    }

    public long receive() throws GracefullyStoppedException {
        try {
            byte[] bytes = new byte[9];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            this.socket.receive(packet);
            return FileLockCommunicator.decode(bytes);
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void stop() {
        this.stopped = true;
        this.socket.close();
    }

    private static byte[] encode(long lockId) throws IOException {
        ByteArrayOutputStream packet = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(packet);
        dataOutput.writeByte(1);
        dataOutput.writeLong(lockId);
        dataOutput.flush();
        return packet.toByteArray();
    }

    private static long decode(byte[] bytes) throws IOException {
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(bytes));
        byte version = dataInput.readByte();
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Unexpected protocol version %s received in lock contention notification message", version));
        }
        return dataInput.readLong();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

