/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.tasks.TaskStatusNagger;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputs
implements TaskInputs {
    private final DefaultConfigurableFileCollection inputFiles;
    private final DefaultConfigurableFileCollection sourceFiles;
    private final FileResolver resolver;
    private final TaskStatusNagger taskStatusNagger;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultTaskInputs(FileResolver resolver, TaskInternal task, TaskStatusNagger taskStatusNagger) {
        this.resolver = resolver;
        this.taskStatusNagger = taskStatusNagger;
        this.inputFiles = new DefaultConfigurableFileCollection(String.format("%s input files", task), resolver, null, new Object[0]);
        this.sourceFiles = new DefaultConfigurableFileCollection(String.format("%s source files", task), resolver, null, new Object[0]);
    }

    @Override
    public boolean getHasInputs() {
        return !this.inputFiles.getFrom().isEmpty() || !this.properties.isEmpty() || !this.sourceFiles.getFrom().isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return new UnionFileCollection(this.inputFiles, this.sourceFiles);
    }

    @Override
    public TaskInputs files(Object ... paths) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.files(Object...)");
        this.inputFiles.from(paths);
        return this;
    }

    @Override
    public TaskInputs file(Object path) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.file(Object)");
        this.files(path);
        return this;
    }

    @Override
    public TaskInputs dir(Object dirPath) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.dir(Object)");
        this.inputFiles.from(this.resolver.resolveFilesAsTree(dirPath));
        return this;
    }

    @Override
    public boolean getHasSourceFiles() {
        return !this.sourceFiles.getFrom().isEmpty();
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public TaskInputs source(Object ... paths) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.source(Object...)");
        this.sourceFiles.from(paths);
        return this;
    }

    @Override
    public TaskInputs source(Object path) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.source(Object)");
        this.sourceFiles.from(path);
        return this;
    }

    @Override
    public TaskInputs sourceDir(Object path) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.sourceDir(Object)");
        this.sourceFiles.from(this.resolver.resolveFilesAsTree(path));
        return this;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> actualProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = this.unwrap(entry.getValue());
            actualProperties.put(entry.getKey(), value);
        }
        return actualProperties;
    }

    private Object unwrap(Object value) {
        while (true) {
            if (value instanceof Callable) {
                Callable callable = (Callable)value;
                try {
                    value = callable.call();
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            if (!(value instanceof Closure)) break;
            Closure closure = (Closure)value;
            value = closure.call();
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return value;
    }

    @Override
    public TaskInputs property(String name, Object value) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.property(String, Object)");
        this.properties.put(name, value);
        return this;
    }

    @Override
    public TaskInputs properties(Map<String, ?> properties) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("TaskInputs.properties(Map)");
        this.properties.putAll(properties);
        return this;
    }
}

