/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFactory
implements IProjectFactory {
    private final Instantiator instantiator;
    private final ProjectRegistry<ProjectInternal> projectRegistry;

    public ProjectFactory(Instantiator instantiator, ProjectRegistry<ProjectInternal> projectRegistry) {
        this.instantiator = instantiator;
        this.projectRegistry = projectRegistry;
    }

    @Override
    public DefaultProject createProject(ProjectDescriptor projectDescriptor, ProjectInternal parent, GradleInternal gradle, ClassLoaderScope classLoaderScope) {
        File buildFile = projectDescriptor.getBuildFile();
        ScriptSource source = !buildFile.exists() ? new StringScriptSource("empty build file", "") : new UriScriptSource("build file", buildFile);
        DefaultProject project = (DefaultProject)this.instantiator.newInstance(DefaultProject.class, new Object[]{projectDescriptor.getName(), parent, projectDescriptor.getProjectDir(), source, gradle, gradle.getServiceRegistryFactory(), classLoaderScope});
        if (parent != null) {
            parent.addChildProject(project);
        }
        this.projectRegistry.addProject(project);
        return project;
    }
}

