/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptHandlerClassLoaderFactory
implements Factory<ClassLoader> {
    private static final Logger LOGGER = Logging.getLogger(ScriptHandlerClassLoaderFactory.class);
    private final ScriptSource scriptSource;
    private final ClassLoaderScope classLoaderScope;

    public ScriptHandlerClassLoaderFactory(ScriptSource scriptSource, ClassLoaderScope classLoaderScope) {
        this.scriptSource = scriptSource;
        this.classLoaderScope = classLoaderScope;
    }

    public ClassLoader create() {
        if (!this.classLoaderScope.isLocked()) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", this.scriptSource);
        }
        return this.classLoaderScope.getScopeClassLoader();
    }
}

