/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.initialization.ClassLoaderCache;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;

public class DefaultClassLoaderScope
implements ClassLoaderScope {
    public static final String STRICT_MODE_PROPERTY = "org.gradle.classloaderscope.strict";
    private final ClassLoaderScope parent;
    private final ClassLoaderScope base;
    private final ClassLoaderCache classLoaderCache;
    private boolean locked;
    private List<ClassLoader> local;
    private ClassLoader scopeClassLoader;
    private MultiParentClassLoader exportingClassLoader;
    private MultiParentClassLoader localClassLoader;
    private ClassLoader childrenParent;

    public DefaultClassLoaderScope(ClassLoaderScope parent, ClassLoaderScope base, ClassLoaderCache classLoaderCache) {
        this.parent = parent;
        this.base = base;
        this.classLoaderCache = classLoaderCache;
    }

    public ClassLoader getChildClassLoader() {
        this.getScopeClassLoader();
        return this.childrenParent;
    }

    public ClassLoaderScope getBase() {
        return this.base;
    }

    public ClassLoader getScopeClassLoader() {
        if (this.scopeClassLoader == null) {
            if (this.locked) {
                if (this.local == null && this.exportingClassLoader == null) {
                    this.childrenParent = this.scopeClassLoader = this.parent.getChildClassLoader();
                } else if (this.exportingClassLoader == null) {
                    this.localClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.parent.getChildClassLoader()});
                    this.scopeClassLoader = new CachingClassLoader((ClassLoader)this.localClassLoader);
                    this.childrenParent = this.parent.getChildClassLoader();
                } else if (this.local == null) {
                    this.childrenParent = this.scopeClassLoader = this.exportingClassLoader;
                } else {
                    this.createFlexibleLoaderStructure();
                }
            } else {
                if (Boolean.getBoolean(STRICT_MODE_PROPERTY)) {
                    throw new IllegalStateException("Attempt to define scope class loader before scope is locked");
                }
                this.createFlexibleLoaderStructure();
            }
            if (this.local != null) {
                for (ClassLoader localClassLoader : this.local) {
                    this.addLocal(localClassLoader);
                }
            }
        }
        return this.scopeClassLoader;
    }

    private void addLocal(ClassLoader newClassLoader) {
        assert (this.localClassLoader != null);
        this.localClassLoader.addParent(newClassLoader);
    }

    private void createFlexibleLoaderStructure() {
        if (this.exportingClassLoader == null) {
            this.exportingClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.parent.getChildClassLoader()});
        }
        this.localClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.exportingClassLoader});
        this.scopeClassLoader = new CachingClassLoader((ClassLoader)this.localClassLoader);
        this.childrenParent = this.exportingClassLoader;
    }

    public ClassLoader addLocal(ClassPath classpath) {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked");
        }
        if (!classpath.isEmpty()) {
            if (this.local == null) {
                this.local = new ArrayList<ClassLoader>(1);
            }
            ClassLoader newClassLoader = this.classLoaderCache.get(this.base.getChildClassLoader(), classpath, null);
            this.local.add(newClassLoader);
            if (this.localClassLoader != null) {
                this.addLocal(newClassLoader);
            }
            return newClassLoader;
        }
        return this.base.getChildClassLoader();
    }

    public ClassLoader export(ClassPath classpath) {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked");
        }
        if (classpath.isEmpty()) {
            return this.parent.getChildClassLoader();
        }
        if (this.exportingClassLoader == null) {
            this.exportingClassLoader = new MultiParentClassLoader(new ClassLoader[0]);
        }
        ClassLoader classLoader = this.classLoaderCache.get(this.parent.getChildClassLoader(), classpath, null);
        this.exportingClassLoader.addParent(classLoader);
        return classLoader;
    }

    public ClassLoaderScope createSibling() {
        return new DefaultClassLoaderScope(this.parent, this.base, this.classLoaderCache);
    }

    public ClassLoaderScope createChild() {
        return new DefaultClassLoaderScope(this, this.base, this.classLoaderCache);
    }

    public ClassLoaderScope createRebasedChild() {
        return new DefaultClassLoaderScope(this, this, this.classLoaderCache);
    }

    public ClassLoaderScope lock() {
        this.locked = true;
        return this;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

