/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.resolution.ArtifactResolutionQuery;
import org.gradle.api.internal.artifacts.dsl.dependencies.ArtifactResolutionQueryFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyHandler
extends GroovyObjectSupport
implements DependencyHandler {
    private final ConfigurationContainer configurationContainer;
    private final DependencyFactory dependencyFactory;
    private final ProjectFinder projectFinder;
    private final ComponentMetadataHandler metadataHandler;
    private final ArtifactResolutionQueryFactory resolutionQueryFactory;

    public DefaultDependencyHandler(ConfigurationContainer configurationContainer, DependencyFactory dependencyFactory, ProjectFinder projectFinder, ComponentMetadataHandler metadataHandler, ArtifactResolutionQueryFactory resolutionQueryFactory) {
        this.configurationContainer = configurationContainer;
        this.dependencyFactory = dependencyFactory;
        this.projectFinder = projectFinder;
        this.metadataHandler = metadataHandler;
        this.resolutionQueryFactory = resolutionQueryFactory;
    }

    @Override
    public Dependency add(String configurationName, Object dependencyNotation) {
        return this.add(configurationName, dependencyNotation, null);
    }

    @Override
    public Dependency add(String configurationName, Object dependencyNotation, Closure configureClosure) {
        return this.doAdd((Configuration)this.configurationContainer.findByName(configurationName), dependencyNotation, configureClosure);
    }

    @Override
    public Dependency create(Object dependencyNotation) {
        return this.create(dependencyNotation, null);
    }

    @Override
    public Dependency create(Object dependencyNotation, Closure configureClosure) {
        Dependency dependency = this.dependencyFactory.createDependency(dependencyNotation);
        return ConfigureUtil.configure(configureClosure, dependency);
    }

    private Dependency doAdd(Configuration configuration, Object dependencyNotation, Closure configureClosure) {
        if (dependencyNotation instanceof Configuration) {
            Configuration other = (Configuration)dependencyNotation;
            if (!this.configurationContainer.contains(other)) {
                throw new UnsupportedOperationException("Currently you can only declare dependencies on configurations from the same project.");
            }
            configuration.extendsFrom(other);
            return null;
        }
        Dependency dependency = this.create(dependencyNotation, configureClosure);
        configuration.getDependencies().add(dependency);
        return dependency;
    }

    @Override
    public Dependency module(Object notation) {
        return this.module(notation, null);
    }

    @Override
    public Dependency project(Map<String, ?> notation) {
        return this.dependencyFactory.createProjectDependencyFromMap(this.projectFinder, notation);
    }

    @Override
    public Dependency module(Object notation, Closure configureClosure) {
        return this.dependencyFactory.createModule(notation, configureClosure);
    }

    @Override
    public Dependency gradleApi() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.GRADLE_API);
    }

    @Override
    public Dependency localGroovy() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.LOCAL_GROOVY);
    }

    public Object methodMissing(String name, Object args) {
        Object[] argsArray = (Object[])args;
        Configuration configuration = (Configuration)this.configurationContainer.findByName(name);
        if (configuration == null) {
            throw new MissingMethodException(name, this.getClass(), argsArray);
        }
        List normalizedArgs = CollectionUtils.flattenCollections((Object[])argsArray);
        if (normalizedArgs.size() == 2 && normalizedArgs.get(1) instanceof Closure) {
            return this.doAdd(configuration, normalizedArgs.get(0), (Closure)normalizedArgs.get(1));
        }
        if (normalizedArgs.size() == 1) {
            return this.doAdd(configuration, normalizedArgs.get(0), null);
        }
        for (Object arg : normalizedArgs) {
            this.doAdd(configuration, arg, null);
        }
        return null;
    }

    @Override
    public void components(Action<? super ComponentMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getComponents());
    }

    @Override
    public ComponentMetadataHandler getComponents() {
        return this.metadataHandler;
    }

    @Override
    public ArtifactResolutionQuery createArtifactResolutionQuery() {
        return this.resolutionQueryFactory.createArtifactResolutionQuery();
    }
}

