/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.TaskStatusNagger;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Task.class);
    private static ThreadLocal<TaskInfo> nextInstance = new ThreadLocal();
    private ProjectInternal project;
    private String name;
    private List<ContextAwareTaskAction> actions = new ArrayList<ContextAwareTaskAction>();
    private String path;
    private boolean enabled = true;
    private DefaultTaskDependency dependencies;
    private DefaultTaskDependency mustRunAfter;
    private DefaultTaskDependency finalizedBy;
    private DefaultTaskDependency shouldRunAfter;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private String group;
    private AndSpec<Task> onlyIfSpec = new AndSpec(new Spec[]{this.createNewOnlyIfSpec()});
    private final TaskOutputsInternal outputs;
    private final TaskInputs inputs;
    private TaskExecuter executer;
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private final LoggingManagerInternal loggingManager;
    private List<TaskValidator> validators = new ArrayList<TaskValidator>();
    private final TaskStatusNagger taskStatusNagger;
    private ObservableList observableActionList;

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        return nextInstance.get();
    }

    private AbstractTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            throw new TaskInstantiationException(String.format("Task of type '%s' has been instantiated directly which is not supported. Tasks can only be created using the DSL.", this.getClass().getName()));
        }
        this.project = taskInfo.project;
        this.name = taskInfo.name;
        assert (this.project != null);
        assert (this.name != null);
        this.path = this.project.absoluteProjectPath(this.name);
        this.state = new TaskStateInternal(this.toString());
        this.dependencies = new DefaultTaskDependency(this.project.getTasks());
        this.mustRunAfter = new DefaultTaskDependency(this.project.getTasks());
        this.finalizedBy = new DefaultTaskDependency(this.project.getTasks());
        this.shouldRunAfter = new DefaultTaskDependency(this.project.getTasks());
        this.services = this.project.getServiceRegistryFactory().createFor(this);
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.getServices().get(Instantiator.class));
        this.taskStatusNagger = (TaskStatusNagger)this.services.get(TaskStatusNagger.class);
        this.outputs = (TaskOutputsInternal)this.services.get(TaskOutputsInternal.class);
        this.inputs = (TaskInputs)this.services.get(TaskInputs.class);
        this.executer = (TaskExecuter)this.services.get(TaskExecuter.class);
        this.observableActionList = new ObservableActionWrapperList(this.actions);
        this.observableActionList.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTask.this.taskStatusNagger.nagAboutMutatingListIfTaskNotInConfigurableState("Task.getActions()", evt);
            }
        });
        this.loggingManager = (LoggingManagerInternal)this.services.get(LoggingManagerInternal.class);
    }

    public static <T extends Task> T injectIntoNewInstance(ProjectInternal project, String name, Callable<T> factory) {
        nextInstance.set(new TaskInfo(project, name));
        try {
            Task task = (Task)factory.call();
            return (T)task;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            nextInstance.set(null);
        }
    }

    @Override
    public TaskState getState() {
        return this.state;
    }

    @Override
    public TaskStateInternal getStateInternal() {
        return this.state;
    }

    @Override
    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = (ProjectInternal)project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Action<? super Task>> getActions() {
        return this.observableActionList;
    }

    @Override
    public List<ContextAwareTaskAction> getTaskActions() {
        return this.observableActionList;
    }

    @Override
    public void setActions(final List<Action<? super Task>> actions) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setActions(Actions<Task>)");
        this.taskStatusNagger.whileDisabled(new Runnable(){

            public void run() {
                AbstractTask.this.deleteAllActions();
                for (Action action : actions) {
                    AbstractTask.this.doLast((Action<? super Task>)action);
                }
            }
        });
    }

    @Override
    public TaskDependencyInternal getTaskDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<Object> getDependsOn() {
        return this.dependencies.getValues();
    }

    @Override
    public void setDependsOn(Iterable<?> dependsOn) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setDependsOn(Iterable)");
        this.dependencies.setValues(dependsOn);
    }

    @Override
    public void onlyIf(Closure onlyIfClosure) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.onlyIf(Closure)");
        this.onlyIfSpec = this.onlyIfSpec.and(onlyIfClosure);
    }

    @Override
    public void onlyIf(Spec<? super Task> onlyIfSpec) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.onlyIf(Spec)");
        this.onlyIfSpec = this.onlyIfSpec.and(new Spec[]{onlyIfSpec});
    }

    @Override
    public void setOnlyIf(Spec<? super Task> spec) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setOnlyIf(Spec)");
        this.onlyIfSpec = this.createNewOnlyIfSpec().and(new Spec[]{spec});
    }

    @Override
    public void setOnlyIf(Closure onlyIfClosure) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setOnlyIf(Closure)");
        this.onlyIfSpec = this.createNewOnlyIfSpec().and(onlyIfClosure);
    }

    private AndSpec<Task> createNewOnlyIfSpec() {
        return new AndSpec(new Spec[]{new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return element == AbstractTask.this && AbstractTask.this.enabled;
            }
        }});
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    @Override
    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    @Override
    public void setDidWork(boolean didWork) {
        this.state.setDidWork(didWork);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setEnabled(boolean)");
        this.enabled = enabled;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Task deleteAllActions() {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.deleteAllActions()");
        this.actions.clear();
        return this;
    }

    @Override
    public final void execute() {
        this.executeWithoutThrowingTaskFailure();
        this.state.rethrowFailure();
    }

    @Override
    public void executeWithoutThrowingTaskFailure() {
        this.executer.execute(this, this.state, new DefaultTaskExecutionContext());
    }

    @Override
    public TaskExecuter getExecuter() {
        return this.executer;
    }

    @Override
    public void setExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public Task dependsOn(Object ... paths) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.dependsOn(Object...)");
        this.dependencies.add(paths);
        return this;
    }

    @Override
    public Task doFirst(Action<? super Task> action) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.doFirst(Action)");
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(0, this.wrap(action));
        return this;
    }

    @Override
    public Task doLast(Action<? super Task> action) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.doLast(Action)");
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(this.wrap(action));
        return this;
    }

    @Override
    public int compareTo(Task otherTask) {
        int depthCompare = this.project.compareTo(otherTask.getProject());
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherTask.getPath());
        }
        return depthCompare;
    }

    public String toString() {
        return String.format("task '%s'", this.path);
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager;
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public ExtensionContainer getExtensions() {
        return this.getConvention();
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public TaskInputs getInputs() {
        return this.inputs;
    }

    @Override
    public TaskOutputsInternal getOutputs() {
        return this.outputs;
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public boolean dependsOnTaskDidWork() {
        TaskDependencyInternal dependency = this.getTaskDependencies();
        for (Task task : dependency.getDependencies(this)) {
            if (!task.getDidWork()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task doFirst(Closure action) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.doFirst(Closure)");
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(0, this.convertClosureToAction(action));
        return this;
    }

    @Override
    public Task doLast(Closure action) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.doLast(Closure)");
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(this.convertClosureToAction(action));
        return this;
    }

    @Override
    public Task leftShift(Closure action) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.leftShit(Closure)");
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(this.taskStatusNagger.leftShift(this.convertClosureToAction(action)));
        return this;
    }

    @Override
    public Task configure(Closure closure) {
        return ConfigureUtil.configure(closure, this, false);
    }

    @Override
    public File getTemporaryDir() {
        File dir = ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryFile(this.getName());
        GFileUtils.mkdirs(dir);
        return dir;
    }

    @Override
    public Factory<File> getTemporaryDirFactory() {
        return new Factory<File>(){

            public File create() {
                return AbstractTask.this.getTemporaryDir();
            }
        };
    }

    @Override
    public void addValidator(TaskValidator validator) {
        this.validators.add(validator);
    }

    @Override
    public List<TaskValidator> getValidators() {
        return this.validators;
    }

    private ContextAwareTaskAction convertClosureToAction(Closure actionClosure) {
        return new ClosureTaskAction(actionClosure);
    }

    private ContextAwareTaskAction wrap(Action<? super Task> action) {
        return new TaskActionWrapper(action);
    }

    @Override
    public void setMustRunAfter(Iterable<?> mustRunAfterTasks) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setMustRunAfter(Iterable)");
        this.mustRunAfter.setValues(mustRunAfterTasks);
    }

    @Override
    public Task mustRunAfter(Object ... paths) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.mustRunAfter(Object...)");
        this.mustRunAfter.add(paths);
        return this;
    }

    @Override
    public TaskDependency getMustRunAfter() {
        return this.mustRunAfter;
    }

    @Override
    public void setFinalizedBy(Iterable<?> finalizedByTasks) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setFinalizedBy(Iterable)");
        this.finalizedBy.setValues(finalizedByTasks);
    }

    @Override
    public Task finalizedBy(Object ... paths) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.finalizedBy(Object...)");
        this.finalizedBy.add(paths);
        return this;
    }

    @Override
    public TaskDependency getFinalizedBy() {
        return this.finalizedBy;
    }

    @Override
    public TaskDependency shouldRunAfter(Object ... paths) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.shouldRunAfter(Object...)");
        this.shouldRunAfter.add(paths);
        return this.shouldRunAfter;
    }

    @Override
    public void setShouldRunAfter(Iterable<?> shouldRunAfterTasks) {
        this.taskStatusNagger.nagIfTaskNotInConfigurableState("Task.setShouldRunAfter(Iterable)");
        this.shouldRunAfter.setValues(shouldRunAfterTasks);
    }

    @Override
    public TaskDependency getShouldRunAfter() {
        return this.shouldRunAfter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObservableActionWrapperList
    extends ObservableList {
        public ObservableActionWrapperList(List delegate) {
            super(delegate);
        }

        public boolean add(Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            return super.add((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        public void add(int index, Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            super.add(index, (Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        public boolean addAll(Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean addAll(int index, Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(index, this.transformToContextAwareTaskActions(actions));
        }

        public boolean removeAll(Collection actions) {
            return super.removeAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean remove(Object action) {
            return super.remove((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        private Collection<ContextAwareTaskAction> transformToContextAwareTaskActions(Collection<Object> c) {
            return Collections2.transform(c, (Function)new Function<Object, ContextAwareTaskAction>(){

                public ContextAwareTaskAction apply(@Nullable Object input) {
                    return AbstractTask.this.wrap((Action<? super Task>)((Action)input));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskActionWrapper
    implements ContextAwareTaskAction {
        private final Action<? super Task> action;

        public TaskActionWrapper(Action<? super Task> action) {
            this.action = action;
        }

        @Override
        public void contextualise(TaskExecutionContext context) {
            if (this.action instanceof ContextAwareTaskAction) {
                ((ContextAwareTaskAction)this.action).contextualise(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute((Object)task);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskActionWrapper)) {
                return false;
            }
            TaskActionWrapper that = (TaskActionWrapper)o;
            return !(this.action != null ? !this.action.equals(that.action) : that.action != null);
        }

        public int hashCode() {
            return this.action != null ? this.action.hashCode() : 0;
        }
    }

    private static class ClosureTaskAction
    implements ContextAwareTaskAction {
        private final Closure closure;

        private ClosureTaskAction(Closure closure) {
            this.closure = closure;
        }

        public void contextualise(TaskExecutionContext context) {
        }

        public void execute(Task task) {
            this.closure.setDelegate((Object)task);
            this.closure.setResolveStrategy(1);
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.closure.getClass().getClassLoader());
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    private static class TaskInfo {
        private final ProjectInternal project;
        private final String name;

        private TaskInfo(ProjectInternal project, String name) {
            this.name = name;
            this.project = project;
        }
    }
}

