/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.process.internal.streams.ExecOutputHandleRunner;
import org.gradle.process.internal.streams.StreamsHandler;
import org.gradle.util.DisconnectableInputStream;

public class StreamsForwarder
implements StreamsHandler {
    private final OutputStream standardOutput;
    private final OutputStream errorOutput;
    private final InputStream input;
    private final boolean readErrorStream;
    private StoppableExecutor executor;
    private ExecOutputHandleRunner standardOutputRunner;
    private ExecOutputHandleRunner errorOutputRunner;
    private ExecOutputHandleRunner standardInputRunner;

    public StreamsForwarder(OutputStream standardOutput, OutputStream errorOutput, InputStream input, boolean readErrorStream) {
        this.standardOutput = standardOutput;
        this.errorOutput = errorOutput;
        this.input = input;
        this.readErrorStream = readErrorStream;
    }

    public void connectStreams(Process process, String processName) {
        DisconnectableInputStream instr = new DisconnectableInputStream(this.input);
        this.standardOutputRunner = new ExecOutputHandleRunner("read standard output of: " + processName, process.getInputStream(), this.standardOutput);
        this.errorOutputRunner = new ExecOutputHandleRunner("read error output of: " + processName, process.getErrorStream(), this.errorOutput);
        this.standardInputRunner = new ExecOutputHandleRunner("write standard input into: " + processName, instr, process.getOutputStream());
        this.executor = new DefaultExecutorFactory().create(String.format("Forward streams with process: %s", processName));
    }

    public void start() {
        this.executor.execute((Runnable)this.standardInputRunner);
        if (this.readErrorStream) {
            this.executor.execute((Runnable)this.errorOutputRunner);
        }
        this.executor.execute((Runnable)this.standardOutputRunner);
    }

    public void stop() {
        try {
            this.standardInputRunner.closeInput();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.executor.stop();
    }
}

