/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.messaging.remote.Address;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.BootstrapSecurityManager;
import org.gradle.process.internal.child.EncodedStream;
import org.gradle.process.internal.child.ImplementationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.BootstrapClassLoaderWorker;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInSystemClassLoaderWorkerFactory
implements WorkerFactory {
    private static final Logger LOGGER = Logging.getLogger(ApplicationClassesInSystemClassLoaderWorkerFactory.class);
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final List<URL> implementationClassPath;
    private final Address serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInSystemClassLoaderWorkerFactory(Object workerId, String displayName, WorkerProcessBuilder processBuilder, List<URL> implementationClassPath, Address serverAddress, ClassPathRegistry classPathRegistry) {
        this.workerId = workerId;
        this.displayName = displayName;
        this.processBuilder = processBuilder;
        this.implementationClassPath = implementationClassPath;
        this.serverAddress = serverAddress;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public void prepareJavaCommand(JavaExecSpec execSpec) {
        execSpec.setMain("jarjar." + GradleWorkerMain.class.getName());
        execSpec.classpath(this.classPathRegistry.getClassPath("WORKER_MAIN").getAsFiles());
        Object requestedSecurityManager = execSpec.getSystemProperties().get("java.security.manager");
        if (requestedSecurityManager != null) {
            execSpec.systemProperty("org.gradle.security.manager", requestedSecurityManager);
        }
        execSpec.systemProperty("java.security.manager", "jarjar." + BootstrapSecurityManager.class.getName());
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outstr = new DataOutputStream(new EncodedStream.EncodedOutput(bytes));
            LOGGER.debug("Writing an application classpath to child process' standard input.");
            outstr.writeInt(this.processBuilder.getApplicationClasspath().size());
            for (File file : this.processBuilder.getApplicationClasspath()) {
                outstr.writeUTF(file.getAbsolutePath());
            }
            outstr.close();
            final InputStream originalStdin = execSpec.getStandardInput();
            InputStream input = (InputStream)ByteStreams.join((InputSupplier[])new InputSupplier[]{ByteStreams.newInputStreamSupplier((byte[])bytes.toByteArray()), new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return originalStdin;
                }
            }}).getInput();
            execSpec.setStandardInput(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public Callable<?> create() {
        ActionExecutionWorker injectedWorker = new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress);
        ImplementationClassLoaderWorker worker = new ImplementationClassLoaderWorker(this.processBuilder.getLogLevel(), this.processBuilder.getSharedPackages(), this.implementationClassPath, injectedWorker);
        byte[] serializedWorker = GUtil.serialize(worker);
        return new BootstrapClassLoaderWorker(this.classPathRegistry.getClassPath("WORKER_PROCESS").getAsURLs(), serializedWorker);
    }
}

