/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.resolve.internal.DependencyResolvingClasspathProvider;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolution;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleMappingPluginResolver
implements PluginResolver {
    private final String name;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final Instantiator instantiator;
    private final Mapper mapper;
    private Action<? super RepositoryHandler> repositoriesConfigurer;

    public ModuleMappingPluginResolver(String name, DependencyResolutionServices dependencyResolutionServices, Instantiator instantiator, Mapper mapper, Action<? super RepositoryHandler> repositoriesConfigurer) {
        this.name = name;
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.instantiator = instantiator;
        this.mapper = mapper;
        this.repositoriesConfigurer = repositoriesConfigurer;
    }

    @Override
    public PluginResolution resolve(PluginRequest pluginRequest) {
        Dependency dependency = this.mapper.map(pluginRequest, this.dependencyResolutionServices.getDependencyHandler());
        if (dependency == null) {
            return null;
        }
        DependencyResolvingClasspathProvider classPathFactory = new DependencyResolvingClasspathProvider(this.dependencyResolutionServices, dependency, this.repositoriesConfigurer);
        return new ClassPathPluginResolution(this.instantiator, pluginRequest.getId(), classPathFactory);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    public static interface Mapper {
        @Nullable
        public Dependency map(PluginRequest var1, DependencyHandler var2);
    }
}

