/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import com.jfrog.bintray.client.api.handle.Bintray;
import com.jfrog.bintray.client.api.model.Pkg;
import com.jfrog.bintray.client.impl.BintrayClient;
import java.util.List;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.plugin.resolve.internal.InvalidPluginRequestException;
import org.gradle.plugin.resolve.internal.ModuleMappingPluginResolver;
import org.gradle.plugin.resolve.internal.PluginRequest;

public class JCenterPluginMapper
implements ModuleMappingPluginResolver.Mapper {
    public static final String BINTRAY_API_OVERRIDE_URL_PROPERTY = JCenterPluginMapper.class.getName() + ".bintray.override";
    public static final String GRADLE_PLUGINS_ORG = "gradle-plugins-development";
    public static final String GRADLE_PLUGINS_REPO = "gradle-plugins";
    public static final String PLUGIN_ID_ATTRIBUTE_NAME = "gradle-plugin-id";

    public Dependency map(PluginRequest request, DependencyHandler dependencyHandler) {
        String pluginId = request.getId();
        Bintray bintrayClient = this.createBintrayClient();
        List results = bintrayClient.subject(GRADLE_PLUGINS_ORG).repository(GRADLE_PLUGINS_REPO).searchForPackage().byAttributeName(PLUGIN_ID_ATTRIBUTE_NAME).equals(pluginId).search();
        if (results.isEmpty()) {
            throw new InvalidPluginRequestException("No plugins found for plugin id " + pluginId);
        }
        if (results.size() > 1) {
            throw new InvalidPluginRequestException("Found more than one plugin for plugin id " + pluginId);
        }
        Pkg pluginPackage = (Pkg)results.get(0);
        List systemIds = pluginPackage.systemIds();
        if (systemIds.isEmpty()) {
            throw new InvalidPluginRequestException("No artifacts in maven layout found for plugin id" + pluginId);
        }
        String version = request.getVersion();
        if (version == null) {
            version = pluginPackage.latestVersion();
        }
        return dependencyHandler.create((String)systemIds.get(0) + ":" + version);
    }

    private Bintray createBintrayClient() {
        String override = System.getProperty(BINTRAY_API_OVERRIDE_URL_PROPERTY);
        if (override == null) {
            return BintrayClient.create();
        }
        return BintrayClient.create((String)override, null, null);
    }
}

