/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import java.net.URLClassLoader;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.resolve.internal.PluginResolution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassPathPluginResolution
implements PluginResolution {
    private final String pluginId;
    private final Instantiator instantiator;
    private final Factory<? extends ClassPath> classPathFactory;

    public ClassPathPluginResolution(Instantiator instantiator, String pluginId, Factory<? extends ClassPath> classPathFactory) {
        this.pluginId = pluginId;
        this.instantiator = instantiator;
        this.classPathFactory = classPathFactory;
    }

    @Override
    public Class<? extends Plugin> resolve(ClassLoader parentClassLoader) {
        ClassPath classPath = (ClassPath)this.classPathFactory.create();
        URLClassLoader classLoader = new URLClassLoader(classPath.getAsURLArray(), parentClassLoader);
        DefaultPluginRegistry pluginRegistry = new DefaultPluginRegistry(classLoader, this.instantiator);
        Class<? extends Plugin> typeForId = pluginRegistry.getTypeForId(this.pluginId);
        return typeForId;
    }
}

