/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.resolve.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.plugin.resolve.internal.InvalidPluginRequestException;
import org.gradle.plugin.resolve.internal.ModuleMappingPluginResolver;
import org.gradle.plugin.resolve.internal.PluginRequest;

public class AndroidPluginMapper
implements ModuleMappingPluginResolver.Mapper {
    public static final String GROUP = "com.android.tools.build";
    public static final String NAME = "gradle";
    public static final String ID = "android";

    public Dependency map(PluginRequest request, DependencyHandler dependencyHandler) {
        if (request.getId().equals(ID)) {
            String version = request.getVersion();
            if (version == null) {
                throw new InvalidPluginRequestException("The 'android' plugin requires a version");
            }
            return dependencyHandler.create(StringUtils.join((Object[])new Object[]{GROUP, NAME, version}, (String)":"));
        }
        return null;
    }
}

