/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.resolve.internal.AndroidPluginMapper;
import org.gradle.plugin.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.resolve.internal.JCenterPluginMapper;
import org.gradle.plugin.resolve.internal.ModuleMappingPluginResolver;
import org.gradle.plugin.resolve.internal.PluginRegistryPluginResolver;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResolverFactory {
    private final PluginRegistry pluginRegistry;
    private final Instantiator instantiator;
    private final DependencyManagementServices dependencyManagementServices;
    private final FileResolver fileResolver;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final ProjectFinder projectFinder = new ProjectFinder(){

        public ProjectInternal getProject(String path) {
            throw new UnknownProjectException("Cannot use project dependencies in a plugin resolution definition.");
        }
    };

    public PluginResolverFactory(PluginRegistry pluginRegistry, Instantiator instantiator, DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, DependencyMetaDataProvider dependencyMetaDataProvider) {
        this.pluginRegistry = pluginRegistry;
        this.instantiator = instantiator;
        this.dependencyManagementServices = dependencyManagementServices;
        this.fileResolver = fileResolver;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
    }

    public PluginResolver createPluginResolver() {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(resolvers);
        return new CompositePluginResolver(resolvers);
    }

    private void addDefaultResolvers(List<PluginResolver> resolvers) {
        resolvers.add(new PluginRegistryPluginResolver(this.pluginRegistry));
        resolvers.add(new ModuleMappingPluginResolver("android plugin resolver", this.createDependencyResolutionServices(), this.instantiator, new AndroidPluginMapper(), new JCenterRepositoryConfigurer()));
        resolvers.add(new ModuleMappingPluginResolver("jcenter plugin resolver", this.createDependencyResolutionServices(), this.instantiator, new JCenterPluginMapper(), new JCenterRepositoryConfigurer()));
    }

    private DependencyResolutionServices createDependencyResolutionServices() {
        return this.dependencyManagementServices.create(this.fileResolver, this.dependencyMetaDataProvider, this.projectFinder, new BasicDomainObjectContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JCenterRepositoryConfigurer
    implements Action<RepositoryHandler> {
        private JCenterRepositoryConfigurer() {
        }

        public void execute(RepositoryHandler repositories) {
            repositories.jcenter();
        }
    }

    private static class BasicDomainObjectContext
    implements DomainObjectContext {
        private BasicDomainObjectContext() {
        }

        public String absoluteProjectPath(String name) {
            return name;
        }
    }
}

