/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.api.logging.LogLevel;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.RenderableOutputEvent;

public class LogEvent
extends RenderableOutputEvent {
    private final String message;
    private final Throwable throwable;

    public LogEvent(long timestamp, String category, LogLevel logLevel, String message, Throwable throwable) {
        super(timestamp, category, logLevel);
        this.message = message;
        this.throwable = throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void render(StyledTextOutput output) {
        output.text(this.message);
        output.println();
        if (this.throwable != null) {
            output.exception(this.throwable);
        }
    }

    public String toString() {
        return String.format("[%s] [%s] %s", new Object[]{this.getLogLevel(), this.getCategory(), this.message});
    }
}

