/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import org.gradle.StartParameter;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.DefaultTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ShortCircuitTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.state.CacheBackedFileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.CacheBackedTaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.state.DefaultTaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.state.InMemoryTaskArtifactCache;
import org.gradle.api.internal.changedetection.state.NoOpDecorator;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.hash.CachingHasher;
import org.gradle.api.internal.hash.DefaultHasher;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteAtMostOnceTaskExecuter;
import org.gradle.api.internal.tasks.execution.PostExecutionAnalysisTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipEmptySourceFilesTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipOnlyIfTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipTaskWithNoActionsExecuter;
import org.gradle.api.internal.tasks.execution.SkipUpToDateTaskExecuter;
import org.gradle.api.internal.tasks.execution.ValidatingTaskExecuter;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.environment.GradleBuildEnvironment;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ListenerManager;

public class TaskExecutionServices {
    TaskExecuter createTaskExecuter(TaskArtifactStateRepository repository, ListenerManager listenerManager) {
        return new ExecuteAtMostOnceTaskExecuter(new SkipOnlyIfTaskExecuter(new SkipTaskWithNoActionsExecuter(new SkipEmptySourceFilesTaskExecuter(new ValidatingTaskExecuter(new SkipUpToDateTaskExecuter(repository, new PostExecutionAnalysisTaskExecuter(new ExecuteActionsTaskExecuter(listenerManager.getBroadcaster(TaskActionListener.class)))))))));
    }

    TaskArtifactStateCacheAccess createCacheAccess(Gradle gradle, CacheRepository cacheRepository, InMemoryTaskArtifactCache inMemoryTaskArtifactCache, GradleBuildEnvironment environment) {
        CacheDecorator decorator = environment.isLongLivingProcess() ? inMemoryTaskArtifactCache : new NoOpDecorator();
        return new DefaultTaskArtifactStateCacheAccess(gradle, cacheRepository, decorator);
    }

    TaskArtifactStateRepository createTaskArtifactStateRepository(Instantiator instantiator, TaskArtifactStateCacheAccess cacheAccess, StartParameter startParameter) {
        DefaultFileSnapshotter fileSnapshotter = new DefaultFileSnapshotter(new CachingHasher(new DefaultHasher(), cacheAccess), cacheAccess);
        OutputFilesSnapshotter outputFilesSnapshotter = new OutputFilesSnapshotter(fileSnapshotter, (IdGenerator<Long>)new RandomLongIdGenerator(), cacheAccess);
        CacheBackedTaskHistoryRepository taskHistoryRepository = new CacheBackedTaskHistoryRepository(cacheAccess, new CacheBackedFileSnapshotRepository(cacheAccess, (IdGenerator<Long>)new RandomLongIdGenerator()));
        return new ShortCircuitTaskArtifactStateRepository(startParameter, instantiator, new DefaultTaskArtifactStateRepository(taskHistoryRepository, instantiator, outputFilesSnapshotter, fileSnapshotter));
    }

    TaskPlanExecutor createTaskExecutorFactory(StartParameter startParameter, ExecutorFactory executorFactory) {
        return new TaskPlanExecutorFactory(startParameter.getParallelThreadCount(), executorFactory).create();
    }
}

