/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.File;
import org.apache.tools.ant.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.ClassGeneratorBackedInstantiator;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.component.DefaultSoftwareComponentContainer;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.initialization.DefaultScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.initialization.ScriptCompileScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.DefaultPluginContainer;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.DefaultAntBuilderFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskContainerFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.configuration.project.DefaultProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.PluginServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.service.scopes.TaskScopeServices;
import org.gradle.invocation.BuildClassLoaderRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.model.ModelRules;
import org.gradle.model.internal.DefaultModelRegistry;
import org.gradle.model.internal.ModelRegistry;
import org.gradle.model.internal.ModelRegistryBackedModelRules;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.internal.DefaultToolingModelBuilderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectScopeServices
extends DefaultServiceRegistry {
    private final ProjectInternal project;

    public ProjectScopeServices(final ServiceRegistry parent, final ProjectInternal project) {
        super(new ServiceRegistry[]{parent});
        this.project = project;
        this.register((Action)new Action<ServiceRegistration>(){

            public void execute(ServiceRegistration registration) {
                registration.add(DomainObjectContext.class, (Object)project);
                ((DependencyManagementServices)parent.get(DependencyManagementServices.class)).addDslServices(registration);
                for (PluginServiceRegistry pluginServiceRegistry : parent.getAll(PluginServiceRegistry.class)) {
                    pluginServiceRegistry.registerProjectServices(registration);
                }
            }
        });
    }

    protected PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild((ScriptCompileScope)this.get(ScriptClassLoaderProvider.class), new DependencyInjectingInstantiator((ServiceRegistry)this));
    }

    protected FileResolver createFileResolver() {
        return new BaseDirFileResolver((FileSystem)this.get(FileSystem.class), this.project.getProjectDir());
    }

    protected LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)this.getFactory(LoggingManagerInternal.class).create();
    }

    protected ProjectConfigurationActionContainer createProjectConfigurationActionContainer() {
        return new DefaultProjectConfigurationActionContainer();
    }

    protected DefaultFileOperations createFileOperations() {
        return new DefaultFileOperations((FileResolver)this.get(FileResolver.class), this.project.getTasks(), (TemporaryFileProvider)this.get(TemporaryFileProvider.class), (Instantiator)this.get(Instantiator.class));
    }

    protected TemporaryFileProvider createTemporaryFileProvider() {
        return new DefaultTemporaryFileProvider(new Factory<File>(){

            public File create() {
                return new File(ProjectScopeServices.this.project.getBuildDir(), "tmp");
            }
        });
    }

    protected Factory<AntBuilder> createAntBuilderFactory() {
        return new DefaultAntBuilderFactory((BuildListener)new AntLoggingAdapter(), this.project);
    }

    protected ToolingModelBuilderRegistry createToolingModelRegistry() {
        return new DefaultToolingModelBuilderRegistry();
    }

    protected PluginContainer createPluginContainer() {
        return new DefaultPluginContainer<ProjectInternal>((PluginRegistry)this.get(PluginRegistry.class), this.project);
    }

    protected ITaskFactory createTaskFactory(ITaskFactory parentFactory) {
        return parentFactory.createChild(this.project, new ClassGeneratorBackedInstantiator((ClassGenerator)this.get(ClassGenerator.class), new DependencyInjectingInstantiator((ServiceRegistry)this)));
    }

    protected Factory<TaskContainerInternal> createTaskContainerInternal() {
        return new DefaultTaskContainerFactory((Instantiator)this.get(Instantiator.class), (ITaskFactory)this.get(ITaskFactory.class), this.project, (ProjectAccessListener)this.get(ProjectAccessListener.class));
    }

    protected SoftwareComponentContainer createSoftwareComponentContainer() {
        Instantiator instantiator = (Instantiator)this.get(Instantiator.class);
        return (SoftwareComponentContainer)instantiator.newInstance(DefaultSoftwareComponentContainer.class, new Object[]{instantiator});
    }

    protected ProjectFinder createProjectFinder() {
        return new ProjectFinder(){

            public ProjectInternal getProject(String path) {
                return ProjectScopeServices.this.project.project(path);
            }
        };
    }

    protected ModelRegistry createModelRegistry() {
        return new DefaultModelRegistry();
    }

    protected ModelRules createModelRules() {
        return (ModelRules)((Instantiator)this.get(Instantiator.class)).newInstance(ModelRegistryBackedModelRules.class, new Object[]{this.get(ModelRegistry.class)});
    }

    protected ScriptHandlerInternal createScriptHandler() {
        DefaultScriptHandlerFactory factory = new DefaultScriptHandlerFactory((DependencyManagementServices)this.get(DependencyManagementServices.class), (FileResolver)this.get(FileResolver.class), (DependencyMetaDataProvider)this.get(DependencyMetaDataProvider.class));
        ScriptCompileScope parentScope = this.project.getParent() != null ? (ScriptCompileScope)this.project.getParent().getServices().get(ScriptCompileScope.class) : ((BuildClassLoaderRegistry)this.get(BuildClassLoaderRegistry.class)).getRootCompileScope();
        return factory.create(this.project.getBuildScriptSource(), parentScope, this.project);
    }

    protected DependencyMetaDataProvider createDependencyMetaDataProvider() {
        return new DependencyMetaDataProvider(){

            public ModuleInternal getModule() {
                return new ProjectBackedModule(ProjectScopeServices.this.project);
            }
        };
    }

    protected ServiceRegistryFactory createServiceRegistryFactory(final ServiceRegistry services) {
        return new ServiceRegistryFactory(){

            public ServiceRegistry createFor(Object domainObject) {
                if (domainObject instanceof TaskInternal) {
                    return new TaskScopeServices(services, ProjectScopeServices.this.project, (TaskInternal)domainObject);
                }
                throw new UnsupportedOperationException();
            }
        };
    }
}

