/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.FilteredTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredScriptBlockTransformer
implements FilteredTransformer<Statement, Statement> {
    private final Spec<Statement> spec;
    private final Transformer<Statement, Statement> transform;

    public <T extends Transformer<? extends Statement, ? super Statement>> FilteredScriptBlockTransformer(Map<String, T> transforms) {
        this.spec = new IsScriptBlockSpec(transforms.keySet());
        this.transform = new ScriptBlockTransformer(transforms);
    }

    @Override
    public Spec<Statement> getSpec() {
        return this.spec;
    }

    @Override
    public Transformer<Statement, Statement> getTransformer() {
        return this.transform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptBlockTransformer
    implements Transformer<Statement, Statement> {
        private final Map<String, ? extends Transformer<? extends Statement, ? super Statement>> transforms;

        public <T extends Transformer<? extends Statement, ? super Statement>> ScriptBlockTransformer(Map<String, T> transforms) {
            this.transforms = transforms;
        }

        public Statement transform(Statement original) {
            ExpressionStatement expressionStatement = (ExpressionStatement)original;
            MethodCallExpression methodCall = (MethodCallExpression)expressionStatement.getExpression();
            String methodName = methodCall.getMethod().getText();
            Transformer<? extends Statement, ? super Statement> transformer = this.transforms.get(methodName);
            if (transformer == null) {
                throw new IllegalStateException("No transformer registered for method call '" + methodName + "'");
            }
            return (Statement)transformer.transform((Object)original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsScriptBlockSpec
    implements Spec<Statement> {
        private final Set<String> names;

        private IsScriptBlockSpec(Set<String> names) {
            this.names = names;
        }

        public boolean isSatisfiedBy(Statement statement) {
            if (!(statement instanceof ExpressionStatement)) {
                return false;
            }
            ExpressionStatement expressionStatement = (ExpressionStatement)statement;
            if (!(expressionStatement.getExpression() instanceof MethodCallExpression)) {
                return false;
            }
            MethodCallExpression methodCall = (MethodCallExpression)expressionStatement.getExpression();
            if (!this.isValidName(methodCall)) {
                return false;
            }
            if (!(methodCall.getArguments() instanceof ArgumentListExpression)) {
                return false;
            }
            ArgumentListExpression args = (ArgumentListExpression)methodCall.getArguments();
            return args.getExpressions().size() == 1 && args.getExpression(0) instanceof ClosureExpression;
        }

        private boolean isValidName(MethodCallExpression methodCall) {
            for (String name : this.names) {
                if (!AstUtils.isMethodOnThis(methodCall, name)) continue;
                return true;
            }
            return false;
        }
    }
}

