/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.TaskSelectionResult;
import org.gradle.execution.taskpath.ResolvedTaskPath;
import org.gradle.execution.taskpath.TaskPathResolver;
import org.gradle.util.CollectionUtils;
import org.gradle.util.NameMatcher;

public class TaskSelector {
    private final TaskNameResolver taskNameResolver;
    private final GradleInternal gradle;
    private final TaskPathResolver taskPathResolver = new TaskPathResolver();

    public TaskSelector(GradleInternal gradle) {
        this(gradle, new TaskNameResolver());
    }

    public TaskSelector(GradleInternal gradle, TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
        this.gradle = gradle;
    }

    public TaskSelection getSelection(String path) {
        ProjectInternal project = this.gradle.getDefaultProject();
        ResolvedTaskPath taskPath = this.taskPathResolver.resolvePath(path, project);
        SetMultimap<String, TaskSelectionResult> tasksByName = taskPath.isQualified() ? this.taskNameResolver.select(taskPath.getTaskName(), taskPath.getProject()) : this.taskNameResolver.selectAll(taskPath.getTaskName(), taskPath.getProject());
        Set tasks = tasksByName.get((Object)taskPath.getTaskName());
        if (!tasks.isEmpty()) {
            return new TaskSelection(path, tasks);
        }
        NameMatcher matcher = new NameMatcher();
        String actualName = matcher.find(taskPath.getTaskName(), tasksByName.keySet());
        if (actualName != null) {
            return new TaskSelection(taskPath.getPrefix() + actualName, tasksByName.get((Object)actualName));
        }
        throw new TaskSelectionException(matcher.formatErrorMessage("task", taskPath.getProject()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskSelection {
        private String taskName;
        private Collection<TaskSelectionResult> taskSelectionResult;

        public TaskSelection(String taskName, Set<TaskSelectionResult> tasks) {
            this.taskName = taskName;
            this.taskSelectionResult = tasks;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Set<Task> getTasks() {
            return (Set)CollectionUtils.collect(this.taskSelectionResult, new LinkedHashSet(), (Transformer)new Transformer<Task, TaskSelectionResult>(){

                public Task transform(TaskSelectionResult original) {
                    return original.getTask();
                }
            });
        }
    }
}

