/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.initialization.ScriptCompileScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.plugins.PluginAware;
import org.gradle.configuration.ImportsReader;
import org.gradle.configuration.ScriptBlockToServiceConfigurationTransformer;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.DefaultScript;
import org.gradle.groovy.scripts.ScriptAware;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.groovy.scripts.internal.FilteredScriptBlockTransformer;
import org.gradle.groovy.scripts.internal.StatementExtractingScriptTransformer;
import org.gradle.internal.Factory;
import org.gradle.internal.Transformers;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.plugin.PluginHandler;
import org.gradle.plugin.internal.DefaultPluginHandler;
import org.gradle.plugin.internal.NonPluggableTargetPluginHandler;
import org.gradle.plugin.internal.PluginRequestApplicator;
import org.gradle.plugin.internal.PluginResolutionApplicator;
import org.gradle.plugin.resolve.internal.PluginRequest;
import org.gradle.plugin.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final ImportsReader importsReader;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final ScriptCompileScope defaultCompileScope;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;
    private final PluginResolver pluginResolver;
    private ClassLoader pluginParentClassLoader;

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, ImportsReader importsReader, ScriptHandlerFactory scriptHandlerFactory, ScriptCompileScope defaultCompileScope, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator, PluginResolver pluginResolver, ClassLoader pluginParentClassLoader) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.importsReader = importsReader;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.defaultCompileScope = defaultCompileScope;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
        this.pluginResolver = pluginResolver;
        this.pluginParentClassLoader = pluginParentClassLoader;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource) {
        return new ScriptPluginImpl(scriptSource);
    }

    static /* synthetic */ ScriptCompileScope access$000(DefaultScriptPluginFactory x0) {
        return x0.defaultCompileScope;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private String classpathClosureName = "buildscript";
        private Class<? extends BasicScript> scriptType = DefaultScript.class;
        private ScriptClassLoaderProvider classLoaderProvider;
        private ScriptCompileScope parentScope = DefaultScriptPluginFactory.access$000(DefaultScriptPluginFactory.this);

        public ScriptPluginImpl(ScriptSource scriptSource) {
            this.scriptSource = scriptSource;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public ScriptPlugin setClasspathClosureName(String name) {
            this.classpathClosureName = name;
            return this;
        }

        @Override
        public ScriptPlugin setParentScope(ScriptCompileScope parentScope) {
            this.parentScope = parentScope;
            return this;
        }

        @Override
        public ScriptPlugin setClassLoaderProvider(ScriptClassLoaderProvider classLoaderProvider) {
            this.classLoaderProvider = classLoaderProvider;
            return this;
        }

        @Override
        public ScriptPlugin setScriptBaseClass(Class<? extends BasicScript> type) {
            this.scriptType = type;
            return this;
        }

        @Override
        public void apply(Object target) {
            DefaultServiceRegistry services = new DefaultServiceRegistry();
            services.add(ScriptPluginFactory.class, (Object)DefaultScriptPluginFactory.this);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, (Object)DefaultScriptPluginFactory.this.instantiator);
            ScriptAware scriptAware = null;
            if (target instanceof ScriptAware) {
                scriptAware = (ScriptAware)target;
                scriptAware.beforeCompile(this);
            }
            ScriptClassLoaderProvider classLoaderProvider = this.classLoaderProvider;
            ScriptSource withImports = DefaultScriptPluginFactory.this.importsReader.withImports(this.scriptSource);
            if (classLoaderProvider == null) {
                ScriptHandlerInternal defaultScriptHandler = DefaultScriptPluginFactory.this.scriptHandlerFactory.create(withImports, this.parentScope);
                services.add(ScriptHandlerInternal.class, (Object)defaultScriptHandler);
                classLoaderProvider = defaultScriptHandler;
            }
            LinkedList<PluginRequest> pluginRequests = new LinkedList<PluginRequest>();
            if (target instanceof PluginAware) {
                services.add(PluginHandler.class, (Object)new DefaultPluginHandler(pluginRequests));
            } else {
                services.add(PluginHandler.class, (Object)new NonPluggableTargetPluginHandler(target));
            }
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(withImports);
            compiler.setClassloader(classLoaderProvider.getBaseCompilationClassLoader());
            ImmutableMap blockTransforms = ImmutableMap.of((Object)this.classpathClosureName, (Object)Transformers.noOpTransformer(), (Object)"plugins", (Object)new ScriptBlockToServiceConfigurationTransformer("__scriptServices", PluginHandler.class));
            FilteredScriptBlockTransformer scriptBlockTransformer = new FilteredScriptBlockTransformer(blockTransforms);
            StatementExtractingScriptTransformer classpathScriptTransformer = new StatementExtractingScriptTransformer(this.classpathClosureName, scriptBlockTransformer);
            compiler.setTransformer(classpathScriptTransformer);
            ScriptRunner<? extends BasicScript> classPathScriptRunner = compiler.compile(this.scriptType);
            classPathScriptRunner.getScript().init(target, (ServiceRegistry)services);
            classPathScriptRunner.run();
            if (!pluginRequests.isEmpty()) {
                PluginResolutionApplicator resolutionApplicator = new PluginResolutionApplicator((PluginAware)target, DefaultScriptPluginFactory.this.pluginParentClassLoader, classLoaderProvider);
                PluginRequestApplicator requestApplicator = new PluginRequestApplicator(DefaultScriptPluginFactory.this.pluginResolver, resolutionApplicator);
                requestApplicator.applyPlugin(pluginRequests);
            }
            classLoaderProvider.updateClassPath();
            compiler.setClassloader(classLoaderProvider.getScriptCompileClassLoader());
            compiler.setTransformer(new BuildScriptTransformer("no_" + classpathScriptTransformer.getId(), classpathScriptTransformer.invert()));
            ScriptRunner<? extends BasicScript> runner = compiler.compile(this.scriptType);
            runner.getScript().init(target, (ServiceRegistry)services);
            if (scriptAware != null) {
                scriptAware.afterCompile(this, runner.getScript());
            }
            runner.run();
        }
    }
}

