/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheFactory
implements CacheFactory {
    private final Map<File, DirCacheReference> dirCaches = new HashMap<File, DirCacheReference>();
    private final FileLockManager lockManager;
    private final Lock lock = new ReentrantLock();

    public DefaultCacheFactory(FileLockManager fileLockManager) {
        this.lockManager = fileLockManager;
    }

    void onOpen(Object cache) {
    }

    void onClose(Object cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentCache open(File cacheDir, String displayName, CacheUsage usage, CacheValidator cacheValidator, Map<String, ?> properties, LockOptions lockOptions, Action<? super PersistentCache> initializer) throws CacheOpenException {
        this.lock.lock();
        try {
            PersistentCache persistentCache = this.doOpen(cacheDir, displayName, usage, cacheValidator, properties, lockOptions, initializer);
            return persistentCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentCache openStore(File storeDir, String displayName, LockOptions lockOptions, Action<? super PersistentCache> initializer) throws CacheOpenException {
        this.lock.lock();
        try {
            PersistentCache persistentCache = this.doOpenStore(storeDir, displayName, lockOptions, initializer);
            return persistentCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            CompositeStoppable.stoppable(this.dirCaches.values()).stop();
        }
        finally {
            this.dirCaches.clear();
            this.lock.unlock();
        }
    }

    private PersistentCache doOpen(File cacheDir, String displayName, CacheUsage usage, CacheValidator validator, Map<String, ?> properties, LockOptions lockOptions, Action<? super PersistentCache> action) {
        File canonicalDir = GFileUtils.canonicalise(cacheDir);
        DirCacheReference dirCacheReference = this.dirCaches.get(canonicalDir);
        if (dirCacheReference == null) {
            DefaultPersistentDirectoryCache cache = new DefaultPersistentDirectoryCache(canonicalDir, displayName, usage, validator, properties, lockOptions, action, this.lockManager);
            cache.open();
            dirCacheReference = new DirCacheReference(cache, properties, lockOptions, usage == CacheUsage.REBUILD);
            this.dirCaches.put(canonicalDir, dirCacheReference);
        } else {
            if (usage == CacheUsage.REBUILD && !dirCacheReference.rebuild) {
                throw new IllegalStateException(String.format("Cannot rebuild cache '%s' as it is already open.", cacheDir));
            }
            if (!lockOptions.equals(dirCacheReference.lockOptions)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different options.", cacheDir));
            }
            if (!properties.equals(dirCacheReference.properties)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different state.", cacheDir));
            }
        }
        return new ReferenceTrackingCache(dirCacheReference);
    }

    private PersistentCache doOpenStore(File storeDir, String displayName, LockOptions lockOptions, Action<? super PersistentCache> initializer) throws CacheOpenException {
        if (initializer != null) {
            throw new UnsupportedOperationException("Initializer actions are not currently supported by the directory store implementation.");
        }
        File canonicalDir = GFileUtils.canonicalise(storeDir);
        DirCacheReference dirCacheReference = this.dirCaches.get(canonicalDir);
        if (dirCacheReference == null) {
            DefaultPersistentDirectoryStore cache = new DefaultPersistentDirectoryStore(canonicalDir, displayName, lockOptions, this.lockManager);
            cache.open();
            dirCacheReference = new DirCacheReference(cache, Collections.emptyMap(), lockOptions, false);
            this.dirCaches.put(canonicalDir, dirCacheReference);
        }
        return new ReferenceTrackingCache(dirCacheReference);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceTrackingCache
    implements PersistentCache {
        private final DirCacheReference reference;

        private ReferenceTrackingCache(DirCacheReference reference) {
            this.reference = reference;
            reference.addReference(this);
        }

        public String toString() {
            return this.reference.cache.toString();
        }

        @Override
        public void close() {
            this.reference.release(this);
        }

        @Override
        public File getBaseDir() {
            return this.reference.cache.getBaseDir();
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
            return this.reference.cache.createCache(parameters);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            return this.reference.cache.createCache(name, keyType, valueSerializer);
        }

        @Override
        public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
            return this.reference.cache.longRunningOperation(operationDisplayName, action);
        }

        @Override
        public void longRunningOperation(String operationDisplayName, Runnable action) {
            this.reference.cache.longRunningOperation(operationDisplayName, action);
        }

        @Override
        public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
            return this.reference.cache.useCache(operationDisplayName, action);
        }

        @Override
        public void useCache(String operationDisplayName, Runnable action) {
            this.reference.cache.useCache(operationDisplayName, action);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirCacheReference
    implements Closeable {
        private final Map<String, ?> properties;
        private final LockOptions lockOptions;
        private final ReferencablePersistentCache cache;
        private final Set<ReferenceTrackingCache> references = new HashSet<ReferenceTrackingCache>();
        private final boolean rebuild;

        public DirCacheReference(ReferencablePersistentCache cache, Map<String, ?> properties, LockOptions lockOptions, boolean rebuild) {
            this.cache = cache;
            this.properties = properties;
            this.lockOptions = lockOptions;
            this.rebuild = rebuild;
            DefaultCacheFactory.this.onOpen(cache);
        }

        public void addReference(ReferenceTrackingCache cache) {
            this.references.add(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(ReferenceTrackingCache cache) {
            DefaultCacheFactory.this.lock.lock();
            try {
                if (this.references.remove(cache) && this.references.isEmpty()) {
                    this.close();
                }
            }
            finally {
                DefaultCacheFactory.this.lock.unlock();
            }
        }

        @Override
        public void close() {
            DefaultCacheFactory.this.onClose(this.cache);
            DefaultCacheFactory.this.dirCaches.values().remove(this);
            this.references.clear();
            this.cache.close();
        }
    }
}

