/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputDirectoryPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction inputDirValidation = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            File fileValue;
            File file = fileValue = value instanceof ConfigurableFileTree ? ((ConfigurableFileTree)value).getDir() : (File)value;
            if (!fileValue.exists()) {
                messages.add(String.format("Directory '%s' specified for property '%s' does not exist.", fileValue, propertyName));
            } else if (!fileValue.isDirectory()) {
                messages.add(String.format("Directory '%s' specified for property '%s' is not a directory.", fileValue, propertyName));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputDirectory.class;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.inputDirValidation);
        final boolean isSourceDir = context.getTarget().getAnnotation(SkipWhenEmpty.class) != null;
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
                if (isSourceDir) {
                    task.getInputs().sourceDir(futureValue);
                } else {
                    task.getInputs().dir(futureValue);
                }
            }
        });
    }
}

